package eu.dnetlib.msro.oai.workflows.nodes;

import javax.annotation.Resource;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.information.oai.utils.OAIParameterNames;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SetCurrentOAIDBJobNode extends SimpleJobNode {

	/** The Constant log. */
	private static final Log log = LogFactory.getLog(SetCurrentOAIDBJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	/** The service locator. */
	@Resource
	private UniqueServiceLocator serviceLocator;
	// overrides the value in the env param
	private String oaiDbName;

	private String xpathToCurrentDB = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'OAIPublisherConfigurationDSResourceType']//CONFIGURATION/CURRENTDB";

	@Override
	protected String execute(final NodeToken token) throws Exception {
		String dbToSet = getTheOAIDBName(token);
		log.fatal("Setting OAI Publisher to use db " + dbToSet);
		String xUpdate = "update value " + xpathToCurrentDB + " with '" + dbToSet + "'";
		this.serviceLocator.getService(ISRegistryService.class).executeXUpdate(xUpdate);
		return Arc.DEFAULT_ARC;
	}

	protected String getTheOAIDBName(final NodeToken token) {
		return StringUtils.isNotBlank(oaiDbName)? oaiDbName : token.getEnv().getAttribute(OAIParameterNames.OAI_DB);
	}

	public String getOaiDbName() {
		return oaiDbName;
	}

	public void setOaiDbName(final String oaiDbName) {
		this.oaiDbName = oaiDbName;
	}

	public String getXpathToCurrentDB() {
		return xpathToCurrentDB;
	}

	public void setXpathToCurrentDB(final String xpathToCurrentDB) {
		this.xpathToCurrentDB = xpathToCurrentDB;

	}

}
