package eu.dnetlib.broker.objects;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by claudio on 22/07/16.
 */
public class Publication {

	private String originalId;

	private List<String> titles = new ArrayList<>();

	private List<String> abstracts = new ArrayList<>();

	private String language;

	private List<String> subjects = new ArrayList<>();

	private List<String> creators = new ArrayList<>();

	private String publicationdate;

	private String publisher;

	private String embargoenddate;

	private List<String> contributor = new ArrayList<>();

	private Journal journal;

	private List<String> collectedFrom = new ArrayList<>();

	private List<Pid> pids = new ArrayList<>();

	private List<Instance> instances = new ArrayList<>();

	private List<ExternalReference> externalReferences = new ArrayList<>();

	private List<Project> projects = new ArrayList<>();

	private List<Dataset> datasets = new ArrayList<>();

	private List<Publication> publications = new ArrayList<>();

	private List<Software> softwares = new ArrayList<>();

	public Publication() {}

	public String getOriginalId() {
		return this.originalId;
	}

	public Publication setOriginalId(final String originalId) {
		this.originalId = originalId;
		return this;
	}

	public List<String> getTitles() {
		return this.titles;
	}

	public Publication setTitles(final List<String> titles) {
		this.titles = titles;
		return this;
	}

	public List<String> getAbstracts() {
		return this.abstracts;
	}

	public Publication setAbstracts(final List<String> abstracts) {
		this.abstracts = abstracts;
		return this;
	}

	public String getLanguage() {
		return this.language;
	}

	public Publication setLanguage(final String language) {
		this.language = language;
		return this;
	}

	public List<String> getSubjects() {
		return this.subjects;
	}

	public Publication setSubjects(final List<String> subjects) {
		this.subjects = subjects;
		return this;
	}

	public List<String> getCreators() {
		return this.creators;
	}

	public Publication setCreators(final List<String> creators) {
		this.creators = creators;
		return this;
	}

	public String getPublicationdate() {
		return this.publicationdate;
	}

	public Publication setPublicationdate(final String publicationdate) {
		this.publicationdate = publicationdate;
		return this;
	}

	public String getPublisher() {
		return this.publisher;
	}

	public Publication setPublisher(final String publisher) {
		this.publisher = publisher;
		return this;
	}

	public String getEmbargoenddate() {
		return this.embargoenddate;
	}

	public Publication setEmbargoenddate(final String embargoenddate) {
		this.embargoenddate = embargoenddate;
		return this;
	}

	public List<String> getContributor() {
		return this.contributor;
	}

	public Publication setContributor(final List<String> contributor) {
		this.contributor = contributor;
		return this;
	}

	public Journal getJournal() {
		return this.journal;
	}

	public Publication setJournal(final Journal journal) {
		this.journal = journal;
		return this;
	}

	public List<String> getCollectedFrom() {
		return this.collectedFrom;
	}

	public Publication setCollectedFrom(final List<String> collectedFrom) {
		this.collectedFrom = collectedFrom;
		return this;
	}

	public List<Pid> getPids() {
		return this.pids;
	}

	public Publication setPids(final List<Pid> pids) {
		this.pids = pids;
		return this;
	}

	public List<Instance> getInstances() {
		return this.instances;
	}

	public Publication setInstances(final List<Instance> instances) {
		this.instances = instances;
		return this;
	}

	public List<ExternalReference> getExternalReferences() {
		return this.externalReferences;
	}

	public Publication setExternalReferences(final List<ExternalReference> externalReferences) {
		this.externalReferences = externalReferences;
		return this;
	}

	public List<Project> getProjects() {
		return this.projects;
	}

	public Publication setProjects(final List<Project> projects) {
		this.projects = projects;
		return this;
	}

	public List<Dataset> getDatasets() {
		return this.datasets;
	}

	public Publication setDatasets(final List<Dataset> datasets) {
		this.datasets = datasets;
		return this;
	}

	public List<Software> getSoftwares() {
		return this.softwares;
	}

	public void setSoftwares(final List<Software> softwares) {
		this.softwares = softwares;
	}

	public List<Publication> getPublications() {
		return this.publications;
	}

	public void setPublications(final List<Publication> publications) {
		this.publications = publications;
	}
}
