package eu.dnetlib.broker.objects;

import java.util.List;

public class Dataset {

	private String originalId;

	private List<String> titles;

	private List<String> collectedFrom;

	private List<Pid> pids;

	private List<Instance> instances;

	public Dataset() {}

	public Dataset(final String originalId, final List<String> titles, final List<String> collectedFrom, final List<Pid> pids, final List<Instance> instances) {
		this.originalId = originalId;
		this.titles = titles;
		this.collectedFrom = collectedFrom;
		this.pids = pids;
		this.instances = instances;
	}

	public String getOriginalId() {
		return this.originalId;
	}

	public Dataset setOriginalId(final String originalId) {
		this.originalId = originalId;
		return this;
	}

	public List<String> getTitles() {
		return this.titles;
	}

	public Dataset setTitles(final List<String> titles) {
		this.titles = titles;
		return this;
	}

	public List<String> getCollectedFrom() {
		return this.collectedFrom;
	}

	public Dataset setCollectedFrom(final List<String> collectedFrom) {
		this.collectedFrom = collectedFrom;
		return this;
	}

	public List<Pid> getPids() {
		return this.pids;
	}

	public Dataset setPids(final List<Pid> pids) {
		this.pids = pids;
		return this;
	}

	public List<Instance> getInstances() {
		return this.instances;
	}

	public Dataset setInstances(final List<Instance> instances) {
		this.instances = instances;
		return this;
	}

}
