package eu.dnetlib.broker.objects;

import java.io.Serializable;

import com.google.common.base.Objects;

/**
 * Created by claudio on 22/07/16.
 */
public class Instance implements Serializable {

	/**
	 *
	 */
	private static final long serialVersionUID = 4064188385743605220L;

	private String url;

	private String license;

	private String hostedby;

	private String instancetype;

	public String getUrl() {
		return url;
	}

	public void setUrl(final String url) {
		this.url = url;
	}

	public String getLicense() {
		return license;
	}

	public void setLicense(final String license) {
		this.license = license;
	}

	public String getHostedby() {
		return hostedby;
	}

	public void setHostedby(final String hostedby) {
		this.hostedby = hostedby;
	}

	public String getInstancetype() {
		return instancetype;
	}

	public void setInstancetype(final String instancetype) {
		this.instancetype = instancetype;
	}

	@Override
	public int hashCode() {
		return Objects.hashCode(getUrl(), getLicense(), getHostedby(), getInstancetype());
	}

	@Override
	public boolean equals(final Object obj) {
		if (!(obj instanceof Instance)) { return false; }
		final Instance that = (Instance) obj;
		return Objects.equal(getUrl(), that.getUrl()) &&
				Objects.equal(getLicense(), that.getLicense()) &&
				Objects.equal(getHostedby(), that.getHostedby()) &&
				Objects.equal(getInstancetype(), that.getInstancetype());
	}
}
