package eu.dnetlib.broker.objects;

import java.io.Serializable;

import com.google.gson.GsonBuilder;

/**
 * Created by claudio on 11/07/16.
 */
public class OpenAireEventPayload implements Serializable {

	/**
	 *
	 */
	private static final long serialVersionUID = 5910606923372311229L;

	private OpenaireBrokerResult result;

	private OpenaireBrokerResult highlight;

	private Provenance provenance;

	private float trust;

	public OpenaireBrokerResult getResult() {
		return result;
	}

	public void setResult(final OpenaireBrokerResult result) {
		this.result = result;
	}

	public OpenaireBrokerResult getHighlight() {
		return highlight;
	}

	public void setHighlight(final OpenaireBrokerResult highlight) {
		this.highlight = highlight;
	}

	public Provenance getProvenance() {
		return provenance;
	}

	public void setProvenance(final Provenance provenance) {
		this.provenance = provenance;
	}

	public float getTrust() {
		return trust;
	}

	public void setTrust(final float trust) {
		this.trust = trust;
	}

	public static OpenAireEventPayload fromJSON(final String json) {
		final GsonBuilder b = new GsonBuilder();
		return b.create().fromJson(json, OpenAireEventPayload.class);
	}

	public String toJSON() {
		final GsonBuilder b = new GsonBuilder();
		return b.create().toJson(this);
	}

}
