package eu.dnetlib.enabling.datasources;

import java.util.Set;

import eu.dnetlib.enabling.datasources.common.Api;
import eu.dnetlib.enabling.datasources.common.ApiParam;
import eu.dnetlib.enabling.datasources.common.Datasource;
import eu.dnetlib.enabling.datasources.common.DsmException;
import eu.dnetlib.enabling.datasources.common.Identity;
import eu.dnetlib.enabling.datasources.common.LocalDatasourceManager;
import eu.dnetlib.enabling.datasources.common.Organization;
import eu.dnetlib.enabling.datasources.common.PidSystem;

public interface LocalOpenaireDatasourceManager extends LocalDatasourceManager<Datasource<Organization<?>, Identity, PidSystem>, Api<ApiParam>> {

	void updateTickets(String dsId, Set<Integer> tickets) throws DsmException;

	Set<Integer> listTickets(String dsId) throws DsmException;

}
