/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.datasources;

import com.google.common.collect.ImmutableMap;
import eu.dnetlib.enabling.datasources.DatasourceFunctions;
import eu.dnetlib.enabling.datasources.common.Api;
import eu.dnetlib.enabling.datasources.common.ApiParam;
import eu.dnetlib.enabling.datasources.common.Datasource;
import eu.dnetlib.enabling.datasources.common.DsmException;
import eu.dnetlib.enabling.datasources.common.Identity;
import eu.dnetlib.enabling.datasources.common.Organization;
import eu.dnetlib.enabling.datasources.common.PidSystem;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.transaction.annotation.Transactional;

public class DatasourceManagerClients {
    private static final Log log = LogFactory.getLog(DatasourceManagerClients.class);
    private static final Resource dsQuery = new ClassPathResource("/eu/dnetlib/enabling/datasources/queries/getDatasource.sql");
    private static final Resource dsQueryByPrefix = new ClassPathResource("/eu/dnetlib/enabling/datasources/queries/getDatasourceByPrefix.sql");
    private static final Resource dsIdentitiesQuery = new ClassPathResource("/eu/dnetlib/enabling/datasources/queries/dsIdentitiesQuery.sql");
    private static final Resource dsOrganizationsQuery = new ClassPathResource("/eu/dnetlib/enabling/datasources/queries/dsOrganizationsQuery.sql");
    private static final Resource listApisByDsId = new ClassPathResource("/eu/dnetlib/enabling/datasources/queries/listApisByDsId.sql");
    private static final Resource isDefinedParamQuery = new ClassPathResource("/eu/dnetlib/enabling/datasources/queries/isDefinedParam.sql");
    private NamedParameterJdbcTemplate jdbcTemplate;
    @Autowired
    private UniqueServiceLocator serviceLocator;

    @Transactional(readOnly=true)
    public List<Map<String, Object>> searchSQL(String sql, Map<String, Object> sqlParams) throws DsmException {
        try {
            log.debug((Object)("Executing SQL: " + sql));
            return this.jdbcTemplate.queryForList(sql, sqlParams);
        }
        catch (Exception e) {
            log.error((Object)"Error executing sql", (Throwable)e);
            throw new DsmException(-1, "Error obtaining datasources from db", (Throwable)e);
        }
    }

    @Transactional(readOnly=true)
    public List<Map<String, Object>> searchSQL(Resource sqlResource, Map<String, Object> sqlParams) throws DsmException {
        try {
            return this.searchSQL(IOUtils.toString((InputStream)sqlResource.getInputStream()), sqlParams);
        }
        catch (Exception e) {
            log.error((Object)"Error executing sql", (Throwable)e);
            throw new DsmException(-1, "Error obtaining datasources from db", (Throwable)e);
        }
    }

    @Transactional
    public void updateSQL(String dsId, String sql, Map<String, Object> sqlparams) throws DsmException {
        log.debug((Object)("Executing query SQL: " + sql));
        this.jdbcTemplate.update(sql, sqlparams);
    }

    @Transactional
    public void updateSQL(String dsId, Resource sqlResource, Map<String, Object> sqlparams) throws DsmException {
        try {
            this.updateSQL(dsId, IOUtils.toString((InputStream)sqlResource.getInputStream()), sqlparams);
        }
        catch (Exception e) {
            log.error((Object)"Error in updateSQL", (Throwable)e);
            throw new DsmException(-1, "Error in updateSQL", (Throwable)e);
        }
    }

    @Transactional(readOnly=true)
    public Datasource<Organization<?>, Identity, PidSystem> getDatasourceById(String id) throws DsmException {
        List<Map<String, Object>> list = this.searchSQL(dsQuery, (Map<String, Object>)ImmutableMap.of((Object)"dsId", (Object)id));
        if (list.size() != 1) {
            throw new DsmException("Invalid number of ds with id: " + id);
        }
        Datasource<Organization<?>, Identity, PidSystem> ds = DatasourceFunctions.mapToDatasource(list.get(0));
        ds.setIdentities(this.searchSQL(dsIdentitiesQuery, (Map<String, Object>)ImmutableMap.of((Object)"dsId", (Object)id)).stream().map(DatasourceFunctions::mapToDsIdentity).collect(Collectors.toSet()));
        ds.setOrganizations(this.searchSQL(dsOrganizationsQuery, (Map<String, Object>)ImmutableMap.of((Object)"dsId", (Object)id)).stream().map(DatasourceFunctions::mapToDsOrganization).collect(Collectors.toSet()));
        return ds;
    }

    public Datasource<Organization<?>, Identity, PidSystem> getDatasourceByPrefix(String prefix) throws DsmException {
        List<Map<String, Object>> list = this.searchSQL(dsQueryByPrefix, (Map<String, Object>)ImmutableMap.of((Object)"prefix", (Object)prefix));
        if (list.size() != 1) {
            throw new DsmException("Invalid number of ds with prefix: " + prefix);
        }
        Datasource<Organization<?>, Identity, PidSystem> ds = DatasourceFunctions.mapToDatasource(list.get(0));
        ds.setIdentities(this.searchSQL(dsIdentitiesQuery, (Map<String, Object>)ImmutableMap.of((Object)"dsId", (Object)ds.getId())).stream().map(DatasourceFunctions::mapToDsIdentity).collect(Collectors.toSet()));
        ds.setOrganizations(this.searchSQL(dsOrganizationsQuery, (Map<String, Object>)ImmutableMap.of((Object)"dsId", (Object)ds.getId())).stream().map(DatasourceFunctions::mapToDsOrganization).collect(Collectors.toSet()));
        return ds;
    }

    @Transactional(readOnly=true)
    public List<Api<ApiParam>> getApis(String dsId) throws DsmException {
        return this.searchSQL(listApisByDsId, (Map<String, Object>)ImmutableMap.of((Object)"dsId", (Object)dsId)).stream().map(DatasourceFunctions::mapToApi).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public boolean isDefinedParam(String apiId, String param) throws DsmException {
        return !this.searchSQL(isDefinedParamQuery, (Map<String, Object>)ImmutableMap.of((Object)"apiId", (Object)apiId, (Object)"param", (Object)param)).isEmpty();
    }

    public Date findNextScheduledExecution(String dsId, String ifaceId) throws DsmException {
        String xquery = "/*[.//DATAPROVIDER/@interface='" + ifaceId + "' and .//SCHEDULING/@enabled='true']//CRON/text()";
        try {
            String cronExpression = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(xquery);
            CronExpression cron = new CronExpression(cronExpression);
            return cron.getNextValidTimeAfter(new Date());
        }
        catch (ISLookUpDocumentNotFoundException e) {
            return null;
        }
        catch (ISLookUpException e) {
            log.error((Object)("Error in xquery: " + xquery), (Throwable)e);
            throw new DsmException(-1, "Error in xquery: " + xquery, (Throwable)e);
        }
        catch (ParseException e) {
            log.error((Object)"Error parsing cron expression", (Throwable)e);
            throw new DsmException(-1, "Error parsing cron expression", (Throwable)e);
        }
    }

    public NamedParameterJdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Required
    public void setJdbcTemplate(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

