/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.usagestats.sushilite.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import eu.dnetlib.usagestats.sushilite.domain.Report;
import eu.dnetlib.usagestats.sushilite.domain.ReportDefinition;
import eu.dnetlib.usagestats.sushilite.domain.ReportException;
import eu.dnetlib.usagestats.sushilite.domain.ReportItem;
import eu.dnetlib.usagestats.sushilite.domain.ReportWrapper;
import eu.dnetlib.usagestats.sushilite.domain.Requestor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ReportResponse {
    private String created;
    private List<ReportException> reportExceptions = new ArrayList<ReportException>();
    private Requestor requestor;
    private ReportDefinition reportDefinition;
    private ReportWrapper reportWrapper;

    public ReportResponse() {
    }

    public ReportResponse(String reportName, String release, String requestorId, String beginDate, String endDate, String repositoryIdentifier, String itemIdentifier, String itemDataType, String hasDoi, String granularity, String callback, List<ReportItem> reportItems, List<ReportException> reportExceptions) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
        Date date = new Date();
        this.created = dateFormat.format(date);
        if (!reportExceptions.isEmpty()) {
            this.reportExceptions = reportExceptions;
        }
        this.requestor = new Requestor(requestorId);
        this.reportDefinition = new ReportDefinition(reportName, release, beginDate, endDate, repositoryIdentifier, itemIdentifier, itemDataType, granularity, Integer.toString(reportItems.size()));
        Report report = new Report(this.created, reportName, release, requestorId, reportItems);
        this.reportWrapper = new ReportWrapper(report);
    }

    @JsonProperty(value="@Created")
    public String getCreated() {
        return this.created;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="Exception")
    public List<ReportException> getReportExceptions() {
        return this.reportExceptions;
    }

    @JsonProperty(value="Requestor")
    public Requestor getRequestor() {
        return this.requestor;
    }

    @JsonProperty(value="ReportDefinition")
    public ReportDefinition getReportDefinition() {
        return this.reportDefinition;
    }

    @JsonProperty(value="Report")
    public ReportWrapper getReportWrapper() {
        return this.reportWrapper;
    }
}

