<RESOURCE_PROFILE>
	<HEADER>
		<RESOURCE_IDENTIFIER value="760183e7-a5d4-4827-9218-3d49ff9fcbd1_VHJhbnNmb3JtYXRpb25SdWxlRFNSZXNvdXJjZXMvVHJhbnNmb3JtYXRpb25SdWxlRFNSZXNvdXJjZVR5cGU="/>
		<RESOURCE_TYPE value="TransformationRuleDSResourceType"/>
		<RESOURCE_KIND value="TransformationRuleDSResources"/>
		<RESOURCE_URI value=""/>
		<DATE_OF_CREATION value="2015-02-27T17:15:30+00:00"/>
	</HEADER>
	<BODY>
		<CONFIGURATION>
			<SOURCE_METADATA_FORMAT name="dbmf" layout="store" interpretation="cleaned"/>
			<SINK_METADATA_FORMAT name="oaf_hbase"/>
			<IMPORTED/>
			<SCRIPT>
				<TITLE>xslt_mapping_datasourceOrganization2hbase</TITLE>
				<CODE>
					<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
					                xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:dr="http://www.driver-repository.eu/namespace/dr"
					                xmlns:dri="http://www.driver-repository.eu/namespace/dri" xmlns:oaa="http://namespace.openaire.eu/oaa"
					                xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:dnet="eu.dnetlib.data.transform.xml.DbmfToHbaseXsltFunctions"
					                version="1.0">

						<xsl:output omit-xml-declaration="yes" indent="yes"/>

						<xsl:template match="/">

							<xsl:variable name="datasourceId" select="dnet:oafSplitId('datasource', //FIELD[@name = 'datasource'])"/>
							<xsl:variable name="organizationId" select="dnet:oafSplitId('organization', //FIELD[@name = 'organization'])"/>

							<ROWS>
								<xsl:if test="string-length($datasourceId) &gt; 0 and string-length($organizationId) &gt; 0">

									<xsl:variable name="datasourceorganization"
									              select="dnet:oafRel('datasourceOrganization', $datasourceId, $organizationId, //FIELD[not(@isNull)], 'provides', 'dnet:datasources_organizations_typologies')"/>
									<xsl:variable name="organizationdatasource"
									              select="dnet:oafRel('datasourceOrganization', $organizationId, $datasourceId, //FIELD[not(@isNull)], 'isProvidedBy', 'dnet:datasources_organizations_typologies')"/>

									<ROW key="{$datasourceId}" columnFamily="datasourceOrganization_provision_provides">
										<QUALIFIER name="{$organizationId}" type="base64">
											<xsl:value-of select="$datasourceorganization"/>
										</QUALIFIER>
									</ROW>
									<ROW key="{$organizationId}" columnFamily="datasourceOrganization_provision_isProvidedBy">
										<QUALIFIER name="{$datasourceId}" type="base64">
											<xsl:value-of select="$organizationdatasource"/>
										</QUALIFIER>
									</ROW>
								</xsl:if>
							</ROWS>

						</xsl:template>

					</xsl:stylesheet>
				</CODE>
			</SCRIPT>
		</CONFIGURATION>
		<STATUS/>
		<SECURITY_PARAMETERS>SECURITY_PARAMETERS</SECURITY_PARAMETERS>
	</BODY>
</RESOURCE_PROFILE>
