<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:template match="/">
		<record xmlns="http://www.openarchives.org/OAI/2.0/"
		        xmlns:dr="http://www.driver-repository.eu/namespace/dr"
		        xmlns:oaf="http://namespace.openaire.eu/oaf">
			<xsl:copy-of select=".//*[local-name()='header']"/>
			<metadata>
				<xsl:for-each select=".//*[local-name()='metadata']/*/*">
					<xsl:choose>
						<xsl:when test="local-name()='type'">
							<dr:CobjCategory>0001</dr:CobjCategory>
						</xsl:when>
						<xsl:when test="local-name()='identifier'">
							<dr:CobjIdentifier>
								<xsl:value-of select="normalize-space(.)"/>
							</dr:CobjIdentifier>
							<xsl:if test="starts-with(., 'doi')">
								<oaf:identifier identifierType="doi">
									<xsl:value-of select="normalize-space(.)"/>
								</oaf:identifier>
							</xsl:if>
						</xsl:when>
						<xsl:when test="local-name()='relation'">
							<xsl:if test="contains(., 'grantAgreement/EC/FP7')">
								<oaf:projectid>
									<xsl:value-of select="concat('corda_______::', substring-after(normalize-space(.), 'FP7/'))"/>
								</oaf:projectid>
							</xsl:if>
						</xsl:when>
						<xsl:when test="local-name()='rights'">
							<oaf:accessrights>
								<xsl:choose>
									<xsl:when test="contains(., 'closed')">CLOSED</xsl:when>
									<xsl:when test="contains(., 'restricted')">RESTRICTED</xsl:when>
									<xsl:when test="contains(., 'embargo')">EMBARGO</xsl:when>
									<xsl:when test="contains(., 'open')">OPEN</xsl:when>
									<xsl:otherwise>UNKNOWN</xsl:otherwise>
								</xsl:choose>
							</oaf:accessrights>
						</xsl:when>
						<xsl:otherwise>
							<xsl:copy-of select="."/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
				<oaf:hostedBy name="DATASOURCE NAME" id="datasource id (database)"/>
				<oaf:collectedFrom name="DATASOURCE NAME" id="datasource id (database)"/>
				<oaf:collectedDatasourceid>datasource id taken from the database, es: opendoar____::2659</oaf:collectedDatasourceid>
			</metadata>
		</record>
	</xsl:template>
</xsl:stylesheet>
