<RESOURCE_PROFILE>
	<HEADER>
		<RESOURCE_IDENTIFIER value="9099673b-b46d-4aae-9f56-321607cbacba_VHJhbnNmb3JtYXRpb25SdWxlRFNSZXNvdXJjZXMvVHJhbnNmb3JtYXRpb25SdWxlRFNSZXNvdXJjZVR5cGU="/>
		<RESOURCE_TYPE value="TransformationRuleDSResourceType"/>
		<RESOURCE_KIND value="TransformationRuleDSResources"/>
		<RESOURCE_URI value=""/>
		<DATE_OF_CREATION value="2015-02-27T17:15:30+00:00"/>
	</HEADER>
	<BODY>
		<CONFIGURATION>
			<SOURCE_METADATA_FORMAT name="dbmf" layout="store" interpretation="cleaned"/>
			<SINK_METADATA_FORMAT name="oaf_hbase"/>
			<IMPORTED/>
			<SCRIPT>
				<TITLE>xslt_mapping_projectContactperson2hbase</TITLE>
				<CODE>
					<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
					                xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:dr="http://www.driver-repository.eu/namespace/dr"
					                xmlns:dri="http://www.driver-repository.eu/namespace/dri" xmlns:oaa="http://namespace.openaire.eu/oaa"
					                xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:dnet="eu.dnetlib.data.transform.xml.DbmfToHbaseXsltFunctions"
					                version="1.0">

						<xsl:output omit-xml-declaration="yes" indent="yes"/>

						<xsl:template match="/">

							<xsl:variable name="projectId" select="dnet:oafSplitId('project', //FIELD[@name = 'project'])"/>
							<xsl:variable name="contactpersonId" select="dnet:oafSplitId('person', //FIELD[@name = 'contactperson'])"/>

							<ROWS>
								<xsl:if test="string-length($projectId) &gt; 0 and string-length($contactpersonId) &gt; 0">

									<xsl:variable name="projectcontactperson"
									              select="dnet:oafRel('projectPerson', $projectId, $contactpersonId, //FIELD[not(@isNull)], 'hasContact', 'dnet:project_person_relations')"/>
									<xsl:variable name="contactpersonproject"
									              select="dnet:oafRel('projectPerson', $contactpersonId, $projectId, //FIELD[not(@isNull)], 'isContact', 'dnet:project_person_relations')"/>

									<ROW key="{$projectId}" columnFamily="projectPerson_contactPerson_hasContact">
										<QUALIFIER name="{$contactpersonId}" type="base64">
											<xsl:value-of select="$projectcontactperson"/>
										</QUALIFIER>
									</ROW>
									<ROW key="{$contactpersonId}" columnFamily="projectPerson_contactPerson_isContact">
										<QUALIFIER name="{$projectId}" type="base64">
											<xsl:value-of select="$contactpersonproject"/>
										</QUALIFIER>
									</ROW>
								</xsl:if>
							</ROWS>

						</xsl:template>

					</xsl:stylesheet>
				</CODE>
			</SCRIPT>
		</CONFIGURATION>
		<STATUS/>
		<SECURITY_PARAMETERS>SECURITY_PARAMETERS</SECURITY_PARAMETERS>
	</BODY>
</RESOURCE_PROFILE>
