<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions"
				exclude-result-prefixes="fn">

	<xsl:variable name="namespacePrefix" select="string('sfi_________')"/>
	<xsl:variable name="funderId" select="concat($namespacePrefix, '::SFI')"/>

	<xsl:template match="/">
		<fundingtree>
			<funder>
				<id>
					<xsl:value-of select="$funderId"/>
				</id>
				<shortname>SFI</shortname>
				<name>
					<xsl:value-of select=".//column[@name='Funder Name']"/>
				</name>
				<jurisdiction>IE</jurisdiction>
			</funder>
			<xsl:variable name="funding" select="normalize-space(.//column[@name='Programme Name'])"/>
			<xsl:variable name="sub_funding" select="normalize-space(.//column[@name='Sub-programme Name'])"/>
			<xsl:if test="$funding">
				<xsl:choose>
					<xsl:when test="$sub_funding">
						<funding_level_1>
							<id>
								<xsl:value-of select="concat($funderId, '::' , $funding , '::' ,$sub_funding)"/>
							</id>
							<description>
								<xsl:value-of select="$sub_funding"/>
							</description>
							<name>
								<xsl:value-of select="$sub_funding"/>
							</name>
							<class>sfi:fundingStream</class>
							<parent>
								<funding_level_0>
									<id>
										<xsl:value-of select="concat($funderId, '::' , $funding)"/>
									</id>
									<description>
										<xsl:value-of select="$funding"/>
									</description>
									<name>
										<xsl:value-of select="$funding"/>
									</name>
									<parent/>
									<class>sfi:fundingStream</class>
								</funding_level_0>
							</parent>
						</funding_level_1>
					</xsl:when>
					<xsl:otherwise>
						<funding_level_0>
							<id>
								<xsl:value-of select="concat($funderId, '::', $funding)"/>
							</id>
							<description>
								<xsl:value-of select="$funding"/>
							</description>
							<name>
								<xsl:value-of select="$funding"/>
							</name>
							<parent></parent>
							<class>sfi:fundingStream</class>
						</funding_level_0>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
		</fundingtree>
	</xsl:template>
</xsl:stylesheet>