/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.actions;

import com.google.gson.Gson;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ExtractOutputPathJobNode
extends SimpleJobNode {
    private String hdfsOutputPathParam;

    protected String execute(NodeToken token) throws Exception {
        String sets = token.getEnv().getAttribute("sets");
        if (StringUtils.isBlank((CharSequence)sets)) {
            throw new MSROException("\u00af\\\\_(\u30c4)_/\u00af cannot find sets on env");
        }
        List setsMap = (List)new Gson().fromJson(sets, List.class);
        if (setsMap == null || setsMap.size() != 1) {
            throw new MSROException("\u00af\\\\_(\u30c4)_/\u00af Sets map from json is wrong!");
        }
        String path = (String)((Map)setsMap.get(0)).get("path");
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new MSROException("Path is empty");
        }
        token.getEnv().setAttribute(this.getHdfsOutputPathParam(), path);
        return Arc.DEFAULT_ARC;
    }

    public String getHdfsOutputPathParam() {
        return this.hdfsOutputPathParam;
    }

    public void setHdfsOutputPathParam(String hdfsOutputPathParam) {
        this.hdfsOutputPathParam = hdfsOutputPathParam;
    }
}

