<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

	<xsl:param name="parentDatasourceId"/>
	<xsl:param name="namespacePrefix"/>

	<xsl:template match="/">
		<xsl:variable name="oName" select="normalize-space(//column[./@name='1'])"/>

		<xsl:choose>
			<xsl:when test="string-length($oName) &gt; 0">
				<record>
					<xsl:copy-of select=".//*[local-name()='header']"/>
					<metadata>
						<xsl:variable name="rid" select="normalize-space(//column[./@name='journalid'])"/>
						<xsl:variable name="datasourceId" select="concat($namespacePrefix, '::', $rid)"/>
						<xsl:variable name="namespacePrefix" select='format-number($rid, "00000")'/>

						<ROWS>
							<ROW table="hostedby_map">
								<FIELD name="_dnet_resource_identifier_">
									<xsl:value-of select="concat('irdb_',$rid,'@@', $parentDatasourceId)"/>
								</FIELD>
								<FIELD name="oa_source_id">
									<xsl:value-of select="$parentDatasourceId"/>
								</FIELD>
								<FIELD name="entry">
									<xsl:value-of select="concat('irdb_',$rid)"/>
								</FIELD>
								<FIELD name="datasourceid">
									<xsl:value-of select="concat('irdb________::',$rid)"/>
								</FIELD>
								<FIELD name="key_type">irdb journal id</FIELD>
							</ROW>
						</ROWS>
					</metadata>
				</record>
			</xsl:when>
			<xsl:otherwise>
				<JUNK/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
