/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.claims;

import eu.dnetlib.enabling.database.DataSourceFactory;
import eu.dnetlib.enabling.database.utils.JdbcTemplateFactory;
import eu.dnetlib.msro.openaireplus.workflows.nodes.claims.Claim;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Component;

@Component
public class ClaimDatabaseUtils {
    @Autowired
    private JdbcTemplateFactory claimsJdbcTemplateFactory;
    @Autowired
    private DataSourceFactory claimsDataSourceFactory;
    private JdbcTemplate jdbcTemplate;
    @Value(value="${dnet.openaire.claims.db.name}")
    private String dbName;

    @PostConstruct
    public void init() {
        this.claimsJdbcTemplateFactory.setDataSourceFactory(this.claimsDataSourceFactory);
        this.jdbcTemplate = this.claimsJdbcTemplateFactory.createJdbcTemplate(this.dbName);
    }

    public int count(String sqlCountQuery) {
        return (Integer)this.jdbcTemplate.queryForObject(sqlCountQuery, Integer.class);
    }

    public Stream<Claim> query(String sqlQuery) {
        final SqlRowSet rowSet = this.jdbcTemplate.queryForRowSet(sqlQuery);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<Claim>(){

            @Override
            public boolean hasNext() {
                return !rowSet.isLast();
            }

            @Override
            public Claim next() {
                if (!rowSet.next()) {
                    throw new NoSuchElementException();
                }
                return ClaimDatabaseUtils.this.asClaim(rowSet);
            }
        }, 1024), false);
    }

    private Claim asClaim(SqlRowSet rs) {
        return new Claim().setSemantics(rs.getString("semantics")).setSource(rs.getString("source_id")).setSourceType(rs.getString("source_type")).setTarget(rs.getString("target_id")).setTargetType(rs.getString("target_type"));
    }
}

