<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
>


	<xsl:param name="parentDatasourceId"/>
	<xsl:template match="/">

		<ROWS>
			<xsl:variable name="issn" select="//column[./@name='ISSN']"/>
			<xsl:variable name="id" select="//column[./@name='ID']"/>

			<ROW table="pangaea_temp_journals">
				<FIELD name="_dnet_resource_identifier_">
					<xsl:value-of select="concat('journal',$id)"/>
				</FIELD>
				<FIELD name="id">
					<xsl:value-of select="concat('journal',$id)"/>
				</FIELD>
				<FIELD name="issn">
					<xsl:value-of select="$issn"/>
				</FIELD>
				<FIELD name="oa_source_id">
					<xsl:value-of select="$parentDatasourceId"/>
				</FIELD>
			</ROW>
		</ROWS>
	</xsl:template>
</xsl:stylesheet>