/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.dhp;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.net.URI;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class DeleteMDStoreHadoopJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(DeleteMDStoreHadoopJobNode.class);
    private String mdId;
    private String mdStoreManagerUrl;

    protected String execute(NodeToken token) throws Exception {
        String url = this.getMdStoreManagerUrl() + "/mdstore/{mdId}";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mdId", this.getMdId());
        URI uri = UriComponentsBuilder.fromUriString((String)url).buildAndExpand(params).toUri();
        log.info((Object)("delete mdstore request: " + uri.toASCIIString()));
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.delete(uri);
        log.info((Object)("mdstore deleted: " + this.mdId));
        return Arc.DEFAULT_ARC;
    }

    public String getMdStoreManagerUrl() {
        return this.mdStoreManagerUrl;
    }

    @Required
    public void setMdStoreManagerUrl(String mdStoreManagerUrl) {
        this.mdStoreManagerUrl = mdStoreManagerUrl;
    }

    public String getMdId() {
        return this.mdId;
    }

    public void setMdId(String mdId) {
        this.mdId = mdId;
    }
}

