/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Sorts;
import eu.dnetlib.common.logging.DnetLogger;
import eu.dnetlib.common.logging.dao.DnetLoggerMongoDao;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class PrepareLodParamJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(PrepareLodParamJobNode.class);
    private static final String SYSTEM_PROFILE_ID = "system:profileId";
    private static final String LOG_DATE = "log:date";
    private static final String IS_COMPLETED_SUCCESSFULLY = "system:isCompletedSuccessfully";
    @Value(value="${dnet.openaire.lod.jsonrels}")
    private String lodJsonRels;
    @Value(value="${dnet.openaire.lod.wfId}")
    private String lodWfId;
    @Value(value="${dnet.openaire.lod.default.date}")
    private String defaultLodDate;
    @Autowired
    private DnetLogger dnetLogger;
    @Autowired
    private DnetLoggerMongoDao mongoDao;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");

    protected String execute(NodeToken token) throws Exception {
        log.info((Object)"prepare LOD update job");
        token.getEnv().setAttribute("lod_jsonRels", this.lodJsonRels);
        token.getEnv().setAttribute("lod_lastExecutionDate", this.getFormattedDate());
        return Arc.DEFAULT_ARC;
    }

    private String getFormattedDate() {
        DBObject dbo = (DBObject)this.getLoggerDao().find(Filters.and((Bson[])new Bson[]{Filters.eq((String)SYSTEM_PROFILE_ID, (Object)this.lodWfId), Filters.eq((String)IS_COMPLETED_SUCCESSFULLY, (Object)"true")})).sort(Sorts.descending((String[])new String[]{LOG_DATE})).limit(1).first();
        if (dbo == null || !dbo.containsField(LOG_DATE)) {
            log.warn((Object)String.format("Cannot find log entry for LOD update workflow, using default date: '%s'", this.defaultLodDate));
            return this.defaultLodDate;
        }
        String lastExecutionDate = this.dateFormat.format(new Date((Long)dbo.get(LOG_DATE)));
        log.debug((Object)String.format("Last LOD execution date: '%s'", lastExecutionDate));
        return lastExecutionDate;
    }

    private MongoCollection<DBObject> getLoggerDao() {
        return this.mongoDao.getDb().getCollection(this.dnetLogger.getName(), DBObject.class);
    }
}

