package eu.dnetlib.msro.openaireplus.workflows.nodes.dhp;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.dhp.schema.mdstore.ValidationType;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class VerifyValidationAlertsSubscriptionJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(VerifyValidationAlertsSubscriptionJobNode.class);

	@Value("${dnet.openaire.dhp.validationAlerts.broker.url}")
	private String brokerBaseUrl;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final String dsId = token.getEnv().getAttribute("parentDatasourceId");
		final String subscribers = token.getEnv().getAttribute("subscribers");

		if (StringUtils.isNoneBlank(dsId, subscribers)) {
			for (final String subscriber : subscribers.split(",")) {
				if (StringUtils.isNotBlank(subscriber)) {
					for (final ValidationType type : ValidationType.values()) {
						performSubscription(dsId, subscriber.trim(), type);
					}
				}
			}
		}

		return Arc.DEFAULT_ARC;
	}

	protected void performSubscription(final String dsId, final String subscriber, final ValidationType type) {
		final RestTemplate restTemplate = new RestTemplate();

		final String url = brokerBaseUrl + "/api/openaire-alerts/subscribe/" + type;

		final HttpHeaders headers = new HttpHeaders();
		headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);

		final MultiValueMap<String, String> map = new LinkedMultiValueMap<>();
		map.add("email", subscriber);
		map.add("dsId", dsId);

		final HttpEntity<MultiValueMap<String, String>> request = new HttpEntity<>(map, headers);

		try {
			restTemplate.postForEntity(url, request, String.class);
		} catch (final Throwable e) {
			if (e instanceof HttpStatusCodeException) {
				final String message = ((HttpStatusCodeException) e).getResponseBodyAsString();
				if (message != null && StringUtils.containsIgnoreCase(message, "already subscribed")) {
					log.debug("The subscription has been already registered");
					return;
				}
			}
			log.error("Subscription failed", e);

			throw e;
		}
	}

	public String getBrokerBaseUrl() {
		return brokerBaseUrl;
	}

	public void setBrokerBaseUrl(final String brokerBaseUrl) {
		this.brokerBaseUrl = brokerBaseUrl;
	}

}
