package eu.dnetlib.msro.openaireplus.workflows.nodes.dhp;

import static eu.dnetlib.dhp.common.Constants.OOZIE_WF_PATH;

import java.util.Optional;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import com.google.gson.Gson;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.dhp.collection.ApiDescriptor;
import eu.dnetlib.dhp.schema.mdstore.Provenance;
import eu.dnetlib.enabling.datasources.common.ApiParam;
import eu.dnetlib.enabling.datasources.common.Datasource;
import eu.dnetlib.enabling.datasources.common.DsmNotFoundException;
import eu.dnetlib.enabling.datasources.common.LocalDatasourceManager;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;

public class PrepareEnvValidationAlertsHadoopJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(PrepareEnvValidationAlertsHadoopJobNode.class);

	@Autowired
	private LocalDatasourceManager<?, ?> dsManager;

	/**
	 * MDStore identifier
	 */
	private String mdId;

	@Value("${dnet.openaire.dhp.validationAlerts.app.path}")
	private String oozieWfPath;

	@Value("${dnet.openaire.dhp.validationAlerts.data.path}")
	private String hdfsValidationAlertsDir;

	@Value("${dnet.openaire.dhp.validationAlerts.index.name}")
	private String validationAlertsIndexName;

	@Value("${dnet.openaire.dhp.validationAlerts.index.host}")
	private String validationAlertsIndexHost;

	@Value("${dnet.openaire.dhp.validationAlerts.broker.url}")
	private String brokerBaseUrl;

	private String overrideSubscribers;

	@Override
	protected String execute(final NodeToken token) throws Exception {

		final String dsId = token.getEnv().getAttribute("parentDatasourceId");
		log.info("dsId: " + dsId);
		final String apiId = token.getEnv().getAttribute(WorkflowsConstants.DATAPROVIDER_INTERFACE);
		log.info("apiId: " + apiId);

		final Optional<ApiDescriptor> opt = dsManager.getApis(dsId)
			.stream()
			.filter(a -> a.getId().equals(apiId))
			.map(a -> {
				final ApiDescriptor res = new ApiDescriptor();
				res.setBaseUrl(a.getBaseurl());
				res.setId(a.getId());
				res.setProtocol(a.getProtocol());
				res.setCompatibilityLevel(a.getCompatibility());
				res.getParams().put(PrepareEnvCollectHadoopJobNode.METADATA_IDENTIFIER_PATH, a.getMetadataIdentifierPath());
				res.getParams()
					.putAll(a.getApiParams()
						.stream()
						.map(o -> (ApiParam) o)
						.collect(Collectors.toMap(ApiParam::getParam, ApiParam::getValue)));
				return res;
			})
			.findFirst();

		if (opt.isPresent()) {

			final Datasource<?, ?, ?> ds = dsManager.getDs(dsId);

			final Provenance provenance = new Provenance();
			provenance.setDatasourceId(dsId);
			provenance.setDatasourceName(ds.getOfficialname());
			provenance.setNsPrefix(ds.getNamespaceprefix());

			token.getEnv().setAttribute("mdId", getMdId());
			token.getEnv().setAttribute(OOZIE_WF_PATH, getOozieWfPath());
			token.getEnv().setAttribute("apiDescription", new Gson().toJson(opt.get()));
			token.getEnv().setAttribute("dataSourceInfo", new Gson().toJson(provenance));
			token.getEnv().setAttribute("workflowId", token.getProcess().getEnv().getAttribute("system:processId"));
			token.getEnv().setAttribute("hdfsValidationAlertsDir", hdfsValidationAlertsDir);
			token.getEnv().setAttribute("validationAlertsIndexName", validationAlertsIndexName);
			token.getEnv().setAttribute("validationAlertsIndexHost", validationAlertsIndexHost);
			token.getEnv().setAttribute("brokerApiBaseUrl", brokerBaseUrl);

			if (StringUtils.isNotBlank(overrideSubscribers)) {
				token.getEnv().setAttribute("subscribers", overrideSubscribers);
			} else {
				token.getEnv().setAttribute("subscribers", ds.getRegisteredby());
			}

			return Arc.DEFAULT_ARC;
		} else {
			throw new DsmNotFoundException("cannot find ds interface: " + apiId);
		}
	}

	public String getMdId() {
		return mdId;
	}

	public void setMdId(final String mdId) {
		this.mdId = mdId;
	}

	public String getOozieWfPath() {
		return oozieWfPath;
	}

	public void setOozieWfPath(final String oozieWfPath) {
		this.oozieWfPath = oozieWfPath;
	}

	public String getHdfsValidationAlertsDir() {
		return hdfsValidationAlertsDir;
	}

	public void setHdfsValidationAlertsDir(final String hdfsValidationAlertsDir) {
		this.hdfsValidationAlertsDir = hdfsValidationAlertsDir;
	}

	public String getValidationAlertsIndexName() {
		return validationAlertsIndexName;
	}

	public void setValidationAlertsIndexName(final String validationAlertsIndexName) {
		this.validationAlertsIndexName = validationAlertsIndexName;
	}

	public String getValidationAlertsIndexHost() {
		return validationAlertsIndexHost;
	}

	public void setValidationAlertsIndexHost(final String validationAlertsIndexHost) {
		this.validationAlertsIndexHost = validationAlertsIndexHost;
	}

	public String getOverrideSubscribers() {
		return overrideSubscribers;
	}

	public void setOverrideSubscribers(final String overrideSubscribers) {
		this.overrideSubscribers = overrideSubscribers;
	}

}
