/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.bulktag;

import com.google.common.base.Joiner;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.bulktag.CommunityConfigurationFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class LoadBulkTaggingConfigurationJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(LoadBulkTaggingConfigurationJobNode.class);
    @Autowired
    private UniqueServiceLocator serviceLocator;
    private String xquery;
    private String bulkTaggingConfParam;
    private String enabledConfParam;
    private boolean enabled;
    private String mappingProtoParam;
    private String mapping;

    public void setMappingProtoParam(String mappingProtoParam) {
        this.mappingProtoParam = mappingProtoParam;
    }

    public String getMappingProtoParam() {
        return this.mappingProtoParam;
    }

    public String getMapping() {
        return this.mapping;
    }

    public void setMapping(String mapping) {
        this.mapping = mapping;
    }

    protected String execute(NodeToken token) throws Exception {
        List res = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(this.getXquery());
        String xmlConf = "<communities>" + Joiner.on((String)" ").join((Iterable)res) + "</communities>";
        token.getEnv().setAttribute(this.getBulkTaggingConfParam(), CommunityConfigurationFactory.newInstance((String)xmlConf).toJson());
        token.getEnv().setAttribute(this.getEnabledConfParam(), (Object)this.isEnabled());
        token.getEnv().setAttribute(this.getMappingProtoParam(), this.getMapping());
        return Arc.DEFAULT_ARC;
    }

    public String getXquery() {
        log.debug((Object)this.xquery);
        return this.xquery;
    }

    public void setXquery(String xquery) {
        this.xquery = xquery;
    }

    public String getBulkTaggingConfParam() {
        return this.bulkTaggingConfParam;
    }

    public void setBulkTaggingConfParam(String bulkTaggingConfParam) {
        this.bulkTaggingConfParam = bulkTaggingConfParam;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getEnabledConfParam() {
        return this.enabledConfParam;
    }

    public void setEnabledConfParam(String enabledConfParam) {
        this.enabledConfParam = enabledConfParam;
    }
}

