package eu.dnetlib.msro.openaireplus.workflows.nodes;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.msro.openaireplus.workflows.nodes.index.EntityGrouperConfigurationLoader;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class LoadEntityLinksJobNode extends SimpleJobNode {

	private static final String INDEX_ENTITY_LINKS = "index.entity.links";

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(LoadEntityLinksJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Autowired
	private EntityGrouperConfigurationLoader grouperConfLoader;

	@Override
	protected String execute(final NodeToken token) throws Exception {

		log.info("loading entity link table");

		String links = grouperConfLoader.load();

		if (StringUtils.isBlank(links)) throw new MSROException("empty links table");

		token.getEnv().setAttribute(INDEX_ENTITY_LINKS, links);

		return Arc.DEFAULT_ARC;
	}

}
