package eu.dnetlib.msro.openaireplus.workflows.nodes;

import org.springframework.beans.factory.annotation.Autowired;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.datasources.common.Api;
import eu.dnetlib.enabling.datasources.common.Datasource;
import eu.dnetlib.enabling.datasources.common.LocalDatasourceManager;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;

public class ObtainOpenaireDataSourceParamsJobNode extends SimpleJobNode {

	private String providerId;

	@Autowired
	private LocalDatasourceManager<Datasource<?, ?, ?>, Api<?>> dsManager;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final String nsPrefix = dsManager.getDs(providerId).getNamespaceprefix();

		token.getEnv().setAttribute("parentDatasourceId", providerId);

		token.getEnv().setAttribute("namespacePrefix", nsPrefix);
		token.getEnv().setAttribute("dateOfCollection", DateUtils.now_ISO8601());

		// these are needed for validation and fill hostedby
		token.getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_ORIGINALID, providerId);
		token.getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_NAMESPACE_PREFIX, nsPrefix);

		token.getFullEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_ORIGINALID, providerId);
		token.getFullEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_NAMESPACE_PREFIX, nsPrefix);

		token.getProcess().getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_ORIGINALID, providerId);
		token.getProcess().getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_NAMESPACE_PREFIX, nsPrefix);

		return Arc.DEFAULT_ARC;

	}

	public String getProviderId() {
		return providerId;
	}

	public void setProviderId(final String providerId) {
		this.providerId = providerId;
	}

}
