package eu.dnetlib.msro.openaireplus.workflows.nodes;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import org.springframework.beans.factory.annotation.Required;

public class PrepareIISPreprocessingParamsV2JobNode extends PrepareIISParamsV2 {

	private String xqueryWosMDStore;

	private String mdStoreWosParam = "import_wos_mdstore_id";

	private String xqueryDatabaseService;

	private String databaseServiceLocationParam = "import_database_service_location";

	private String xqueryDataciteObjectStore;

	private String dataciteObjectStoreParam = "import_content_datacite_objectstores_csv";

	private String xqueryWosObjectStore;

	private String wosObjectStorePlaintextParam = "import_content_wos_plaintext_objectstores_csv";

	@Override
	protected String execute(final NodeToken token) throws Exception {
		super.prepare(token);

		token.getEnv().setAttribute(getMdStoreWosParam(), getProfileId(getXqueryWosMDStore()));
		token.getEnv().setAttribute(getDatabaseServiceLocationParam(), getServiceEndpoint(getXqueryDatabaseService()));

		token.getEnv().setAttribute(getDataciteObjectStoreParam(), getFilteredObjectStoreCSV(getXqueryDataciteObjectStore()));
		token.getEnv().setAttribute(getWosObjectStorePlaintextParam(), getProfileId(getXqueryWosObjectStore()));

		return Arc.DEFAULT_ARC;
	}

	public String getXqueryWosMDStore() {
		return xqueryWosMDStore;
	}

	@Required
	public void setXqueryWosMDStore(final String xqueryWosMDStore) {
		this.xqueryWosMDStore = xqueryWosMDStore;
	}

	public String getMdStoreWosParam() {
		return mdStoreWosParam;
	}

	public void setMdStoreWosParam(final String mdStoreWosParam) {
		this.mdStoreWosParam = mdStoreWosParam;
	}

	public String getXqueryDatabaseService() {
		return xqueryDatabaseService;
	}

	@Required
	public void setXqueryDatabaseService(final String xqueryDatabaseService) {
		this.xqueryDatabaseService = xqueryDatabaseService;
	}

	public String getDatabaseServiceLocationParam() {
		return databaseServiceLocationParam;
	}

	public void setDatabaseServiceLocationParam(final String databaseServiceLocationParam) {
		this.databaseServiceLocationParam = databaseServiceLocationParam;
	}

	public String getWosObjectStorePlaintextParam() {
		return wosObjectStorePlaintextParam;
	}

	public void setWosObjectStorePlaintextParam(final String wosObjectStorePlaintextParam) {
		this.wosObjectStorePlaintextParam = wosObjectStorePlaintextParam;
	}

	public String getXqueryWosObjectStore() {
		return xqueryWosObjectStore;
	}

	@Required
	public void setXqueryWosObjectStore(final String xqueryWosObjectStore) {
		this.xqueryWosObjectStore = xqueryWosObjectStore;
	}

	public String getXqueryDataciteObjectStore() {
		return xqueryDataciteObjectStore;
	}

	@Required
	public void setXqueryDataciteObjectStore(final String xqueryDataciteObjectStore) {
		this.xqueryDataciteObjectStore = xqueryDataciteObjectStore;
	}

	public String getDataciteObjectStoreParam() {
		return dataciteObjectStoreParam;
	}

	public void setDataciteObjectStoreParam(final String dataciteObjectStoreParam) {
		this.dataciteObjectStoreParam = dataciteObjectStoreParam;
	}

}
