package eu.dnetlib.msro.openaireplus.workflows.nodes.dataFlowMonitoring;

import java.io.IOException;
import javax.annotation.Resource;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.monitoring.core.sensors.SensorCreationException;
import eu.dnetlib.monitoring.core.sensors.SensorFactory;
import eu.dnetlib.monitoring.core.sensors.collection.SensorWrapper;
import eu.dnetlib.monitoring.core.sensors.collection.index.solr.SolrSensor;
import eu.dnetlib.monitoring.core.sensors.collection.kv.redis.RedisSensor;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TriggerPrepublicMonitoringScenarioJobNode extends SimpleJobNode {

	private final Log log = LogFactory.getLog(TriggerPrepublicMonitoringScenarioJobNode.class);

	private final static String SOLR_COLLECTION_POSTFIX = "-index-openaire";
	private String mdFormat;

	@Resource
	private UniqueServiceLocator serviceLocator;

	private SolrSensor solrSensor;
	private RedisSensor redisSensor;
	private SensorWrapper wrapper;

	@Override
	protected String execute(final NodeToken token) throws IOException, InstantiationException, IllegalAccessException, InterruptedException,
			ISLookUpException, SensorCreationException {
		log.info("Execution of TriggerPrepublicMonitoringScenarioJobNode");

		/* Configuring SOLR sensor */
		String actualCollection = mdFormat + SOLR_COLLECTION_POSTFIX;
		log.info("At this round, the Pre-public monitoring scenario will check against " + actualCollection + " SOLR collection");
		solrSensor = (SolrSensor) SensorFactory.createSensorWithConfiguration(SolrSensor.class, "prepublic", "solr");
		solrSensor.getConfiguration().setParam("collection", actualCollection);
		solrSensor.reinitialize();

		/* Configuring Redis sensor */
		redisSensor = (RedisSensor) SensorFactory.createSensorWithConfiguration(RedisSensor.class, "prepublic", "redis");

		/* Wrapping the two sensors together */
		wrapper = (SensorWrapper) SensorFactory.createSensor(SensorWrapper.class);
		wrapper.registerSensor(solrSensor);
		wrapper.registerSensor(redisSensor);

		log.info("Measuring prepublic scenario");
		wrapper.measure();
		log.info("DONE!");
		return Arc.DEFAULT_ARC;
	}

	public String getMdFormat() {
		return mdFormat;
	}

	public void setMdFormat(final String mdFormat) {
		this.mdFormat = mdFormat;
	}

}
