package eu.dnetlib.msro.openaireplus.workflows.nodes.index;

import java.util.List;
import java.util.Queue;
import javax.annotation.Resource;

import com.google.common.collect.Queues;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;

/**
 * Supercedes eu.dnetlib.msro.openaireplus.workflows.nodes.index.FindSearchServiceJobNode.
 * Returns a queue of SearchService ids that match the xquery and saves it in the env with the name 'searchService_ids'.
 * Use with eu.dnetlib.msro.openaireplus.workflows.nodes.index.SwitchIndexesJobNode
 *
 * @author claudio, alessia
 */
public class FindSearchServicesJobNode extends SimpleJobNode {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(FindSearchServicesJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Resource
	private UniqueServiceLocator serviceLocator;

	@Value(value = "${dnet.openaire.service.search.lookup.xquery}")
	private String xquery;

	/**
	 * {@inheritDoc}
	 *
	 * @throws ISLookUpException
	 * @throws MSROException
	 * @see com.googlecode.sarasvati.mem.MemNode#execute(com.googlecode.sarasvati.Engine, NodeToken)
	 */
	@Override
	public String execute(final NodeToken token) throws ISLookUpException, MSROException {

		log.info("lookup for search service: " + getXquery());

		List<String> searchServiceIds = serviceLocator.getService(ISLookUpService.class).quickSearchProfile(getXquery());
		log.info("SearchService found: " + searchServiceIds.size());
		Queue<String> q = Queues.newLinkedBlockingQueue(searchServiceIds);

		if (searchServiceIds.isEmpty()) {
			return "notFound";
		} else {
			token.getEnv().setTransientAttribute("searchService_ids", q);
			return "found";
		}
	}

	public String getXquery() {
		return xquery;
	}

	public void setXquery(final String xquery) {
		this.xquery = xquery;
	}
}
