package eu.dnetlib.msro.openaireplus.workflows.nodes.stats;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Ask the StatsManagerService to backup the stats cache of the portal specified by the additional BB parameter
 * <code>StatsManagerServiceBBAction.BACKUP_CACHE.getTargetPortalParamName()</code>. The cache can be restored with the last generated backup by
 * sending a "restore" BB message.
 *
 * @author alessia
 * @see RestoreStatsCacheJobNode
 */
public class BackupStatsCacheJobNode extends AbstractStatsJobNode {

	private static final Log log = LogFactory.getLog(BackupStatsCacheJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) throws Exception {
		job.setAction(StatsManagerServiceBBAction.BACKUP_CACHE.action());
		String portal = getPortalName(token);
		if (StringUtils.isNotBlank(portal)) {
			job.getParameters().put(StatsManagerServiceBBAction.BACKUP_CACHE.getTargetPortalParamName(), portal);
		} else {
			log.warn(StatsManagerServiceBBAction.BACKUP_CACHE.getTargetPortalParamName() + " not set. The StatsManagerService will use its default.");
		}
	}
}
