<NODE name="SET_INFO" isStart="true" type="SetProviderInfo">
	<DESCRIPTION>Set information about current provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
		<PARAM required="true" type="string" name="api" managedBy="system">$params.("dataprovider:interface")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="fetchOriginals"/>
		<ARC to="obtainParams" />
	</ARCS>
</NODE>

<NODE name="fetchOriginals" type="FetchMDStoreRecords">
	<DESCRIPTION>Fetch records from MDStore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system" category="MDSTORE_ID">$params.("harv_id")$</PARAM>
		<PARAM required="true" type="string" name="mdFormat" managedBy="system">$params.("harv_format")$</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">orig_dataset_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="transformDatasets"/>
	</ARCS>
</NODE>

<NODE name="obtainParams" type="ObtainOpenaireDataSourceParams">
	<DESCRIPTION>Fetch records from MDStore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="transformDatasets"/>
	</ARCS>
</NODE>

<NODE name="transformDatasets" type="ApplyXslt" isJoin="true">
	<DESCRIPTION>Transform original records to Datasets</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="xsltClasspath" managedBy="user" function="listFiles('/eu/dnetlib/msro/openaireplus/workflows/repo-hi/xslt-datacite','xsl')"></PARAM>
		<PARAM required="true" type="string" name="inputEprParam" managedBy="system">orig_dataset_epr</PARAM>
		<PARAM required="true" type="string" name="outputEprParam" managedBy="system">datasets_epr</PARAM>		 
	</PARAMETERS>
	<ARCS>
		<ARC to="cleanDataset"/>
	</ARCS>
</NODE>

<NODE name="cleanDataset" type="Transform">
	<DESCRIPTION>Clean dataset records</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="ruleId" managedBy="user" category="TRANSFORMATION_RULE_ID" function="listProfiles('TransformationRuleDSResourceType', '//TITLE')"></PARAM>
		<PARAM required="true" type="string" name="inputEprParam" managedBy="system">datasets_epr</PARAM>
		<PARAM required="true" type="string" name="outputEprParam" managedBy="system">cleaned_datasets_epr</PARAM>		 
	</PARAMETERS>
	<ARCS>
		<ARC to="storeDatasetsRecords"/>
	</ARCS>
</NODE>

<NODE name="storeDatasetsRecords" type="StoreMDStoreRecords">
	<DESCRIPTION>Store mdtore records</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system" category="MDSTORE_ID">$params.("tranODF_id")$</PARAM>
		<PARAM required="true" type="string" name="storingType" managedBy="system">REFRESH</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">cleaned_datasets_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="UPDATE_INFO"/>
	</ARCS>
</NODE>

<NODE name="UPDATE_INFO" type="MDStoreToApiExtraField">
	<DESCRIPTION>Update datasouce API extra fields</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system">$params.("tranODF_id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceInterface" managedBy="system">$params.("dataprovider:interface")$</PARAM>
		<PARAM required="true" type="string" name="extraFieldForTotal" managedBy="system">last_aggregation_total</PARAM>
		<PARAM required="true" type="string" name="extraFieldForDate" managedBy="system">last_aggregation_date</PARAM>
		<PARAM required="true" type="string" name="extraFieldForMdId" managedBy="system">last_aggregation_mdId</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="success"/>
	</ARCS>
</NODE>
