 <NODE name="SET_INFO" isStart="true" type="SetProviderInfo">
	<DESCRIPTION>Set information about current provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
		<PARAM required="true" type="string" name="api" managedBy="system">$params.("dataprovider:interface")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="SELECT_MODE"/>
	</ARCS>
</NODE>

<NODE name="SELECT_MODE" type="Selection">
	<DESCRIPTION>Set information about current provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="selection" managedBy="user" function="validValues(['REFRESH','INCREMENTAL'])">INCREMENTAL</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="DropContentObjectStore" name="REFRESH" />
		<ARC to="fetchOriginals" name="INCREMENTAL" />
	</ARCS>
</NODE>

<NODE name="DropContentObjectStore" type="DropContentObjectStore">
	<DESCRIPTION>Refresh content on the object Store</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="objectstoreId" managedBy="system" category="OBJECTSTORE_ID">$params.("objs_id")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="fetchOriginals"/>
	</ARCS>
</NODE>

<NODE name="fetchOriginals" type="FetchMDStoreRecords">
	<DESCRIPTION>Fetch records from MDStore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="user"></PARAM>
		<PARAM required="true" type="string" name="mdFormat" managedBy="system">OAF</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">orig_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="STOREOBJECT"/>
	</ARCS>
</NODE>

<NODE name="STOREOBJECT" type="DownloadIntoObjectStore">
	<DESCRIPTION>Store files into objectStore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="idXpath" managedBy="user">//*[local-name()='objIdentifier']</PARAM>		
		<PARAM required="true" type="string" name="objectStoreId" managedBy="system" category="OBJECTSTORE_ID">$params.("objs_id")$</PARAM>		
		<PARAM required="true" type="string" name="eprParam" managedBy="system">orig_epr</PARAM>
		<PARAM required="false" type="string" name="objectIsInsideEpr" managedBy="system">true</PARAM>
		<PARAM required="true" type="string" name="mimeType" managedBy="user" function="validValues(['pdf', 'application/pdf', 'xml', 'file::WoS', 'text', 'text/plain','text/html'])"></PARAM>
		<PARAM required="true" type="string" name="storageType" managedBy="user" function="validValues(['incremental', 'refresh'])">incremental</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="updateSizeObjectStore"/>
	</ARCS>
</NODE>
<NODE name="updateSizeObjectStore" type="UpdateObjectStoreSize">
	<DESCRIPTION>Download records</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="objectStoreIdParam" managedBy="system" category="OBJECTSTORE_ID">$params.("objs_id")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="UPDATE_INFO"/>
	</ARCS>
</NODE>

<NODE name="UPDATE_INFO" type="ObjectStoreToApiExtraField">
	<DESCRIPTION>Update datasouce API extra fields</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="objId" managedBy="system">$params.("objs_id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceInterface" managedBy="system">$params.("dataprovider:interface")$</PARAM>
		<PARAM required="true" type="string" name="extraFieldForTotal" managedBy="system">last_download_total</PARAM>
		<PARAM required="true" type="string" name="extraFieldForDate" managedBy="system">last_download_date</PARAM>
		<PARAM required="true" type="string" name="extraFieldForObjId" managedBy="system">last_download_objId</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="success"/>
	</ARCS>
</NODE>
