/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes;

import com.google.common.collect.Iterables;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.config.ConfigurationEnumerator;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.hadoop.SubmitHadoopJobNode;
import java.util.NoSuchElementException;
import javax.annotation.Resource;
import org.apache.hadoop.conf.Configuration;

public class IISCacheBuilderJobNode
extends SubmitHadoopJobNode {
    @Resource
    protected ConfigurationEnumerator configurationEnumerator;
    @Resource
    private UniqueServiceLocator serviceLocator;
    private String xqueryObjectStoreService;
    private String oozieWfAppPath;
    private String objectStoreId;

    protected void prepareJob(BlackboardJob job, NodeToken token) throws Exception {
        Configuration conf = this.configurationEnumerator.get(ClusterName.valueOf((String)this.getCluster()));
        String nameNode = conf.get("fs.defaultFS");
        job.getParameters().put("nameNode", nameNode);
        job.getParameters().put("jobTracker", conf.get("mapred.job.tracker"));
        job.getParameters().put("objectstore_service_location", this.getServiceEndpoint(this.getXqueryObjectStoreService()));
        job.getParameters().put("approved_objectstores_csv", this.getObjectStoreId());
        job.getParameters().put("execution_environment", "cache_builder_" + this.getObjectStoreId());
        super.prepareJob(job, token);
    }

    protected String getServiceEndpoint(String xquery) throws MSROException {
        try {
            return (String)Iterables.getOnlyElement((Iterable)((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(xquery));
        }
        catch (ISLookUpException e) {
            throw new MSROException("unable to fetch service endpoint", (Throwable)e);
        }
        catch (NoSuchElementException e) {
            throw new MSROException("unable to find service endpoint, xquery: " + xquery, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new MSROException("more than one services found, we assume to have only one available", (Throwable)e);
        }
    }

    public String getOozieWfAppPath() {
        return this.oozieWfAppPath;
    }

    public void setOozieWfAppPath(String oozieWfAppPath) {
        this.oozieWfAppPath = oozieWfAppPath;
    }

    public String getObjectStoreId() {
        return this.objectStoreId;
    }

    public void setObjectStoreId(String objectStoreId) {
        this.objectStoreId = objectStoreId;
    }

    public String getXqueryObjectStoreService() {
        return this.xqueryObjectStoreService;
    }

    public void setXqueryObjectStoreService(String xqueryObjectStoreService) {
        this.xqueryObjectStoreService = xqueryObjectStoreService;
    }
}

