/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.contexts;

import com.google.common.collect.Maps;
import com.ximpleware.AutoPilot;
import com.ximpleware.VTDException;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import eu.dnetlib.data.transform.xml.AbstractDNetXsltFunctions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.joda.time.DateTime;

public class BuildH2020FETTaxonomy {
    private static final Log log = LogFactory.getLog(BuildH2020FETTaxonomy.class);
    private Iterator<String> projects;
    private Map<String, Map<String, Map<String, List<Info>>>> dic = Maps.newHashMap();

    public void setIterator(Iterator<String> projects) {
        this.projects = projects;
    }

    public String parseProjects() throws Exception {
        while (this.projects.hasNext()) {
            this.parse(this.projects.next());
        }
        return this.getTaxonomy();
    }

    public String getTaxonomy() throws Exception {
        Document taxonomy = DocumentHelper.createDocument();
        Element root1 = taxonomy.addElement("RESOURCE_PROFILE");
        this.createHeader(root1);
        Element body = root1.addElement("BODY");
        Element configurationElement = body.addElement("CONFIGURATION");
        this.createContext(configurationElement);
        body.addElement("STATUS");
        body.addElement("SECURITY_PARAMETERS");
        return taxonomy.getDocument().asXML();
    }

    private void createContext(Element configurationElement) {
        Element context = configurationElement.addElement("context");
        context.addAttribute("type", "community");
        context.addAttribute("id", "fet-h2020");
        context.addAttribute("label", "FET H2020");
        for (Map.Entry<String, Map<String, Map<String, List<Info>>>> entry : this.dic.entrySet()) {
            String type = entry.getKey();
            Element cat = context.addElement("category");
            String catid = "fet-h2020::" + type.toLowerCase();
            cat.addAttribute("id", catid);
            cat.addAttribute("label", "FET " + type);
            cat.addAttribute("claim", "false");
            for (Map.Entry<String, Map<String, List<Info>>> entryst : this.dic.get(type).entrySet()) {
                String subtype = entryst.getKey();
                for (Map.Entry<String, List<Info>> entryp : this.dic.get(type).get(subtype).entrySet()) {
                    String opt = entryp.getKey();
                    Element subcat = cat.addElement("concept");
                    String proj_md5 = AbstractDNetXsltFunctions.md5((String)opt).substring(0, 12);
                    String subcatid = catid + "::" + proj_md5;
                    subcat.addAttribute("id", subcatid);
                    Element pa = subcat.addElement("param");
                    pa.addAttribute("name", "CALL_ID");
                    List<Info> projectRows = this.dic.get(type).get(subtype).get(opt);
                    if (!projectRows.isEmpty()) {
                        for (Info row : projectRows) {
                            this.createProjectConcept(row, subcat, subcatid);
                        }
                        subcat.addAttribute("label", projectRows.get(0).getCallname());
                        subcat.addAttribute("claim", "false");
                        pa.setText(projectRows.get(0).getCallID());
                        continue;
                    }
                    throw new RuntimeException("The lis of projects for " + subcatid + " is empty. This exception should never be thrown.");
                }
            }
        }
    }

    private void createProjectConcept(Info row, Element father, String prefix) {
        String code = row.getCode();
        String acronym = row.getAcronym();
        String title = row.getTitle();
        String projcallid = row.getProjcallid();
        Element concept = father.addElement("concept");
        concept.addAttribute("id", prefix + "::" + code);
        concept.addAttribute("label", title);
        concept.addAttribute("claim", "true");
        Element p = concept.addElement("param");
        p.addAttribute("name", "CD_PROJ_ID");
        p.setText(code);
        p = concept.addElement("param");
        p.addAttribute("name", "CD_CALL_ID");
        p.setText(projcallid);
        p = concept.addElement("param");
        p.addAttribute("name", "CD_PROJECT_NUMBER");
        p.setText(code);
        p = concept.addElement("param");
        p.addAttribute("name", "CD_ACRONYM");
        p.setText(acronym);
        p = concept.addElement("param");
        p.addAttribute("name", "CD_FRAMEWORK");
        p.setText("H2020");
        p = concept.addElement("param");
        p.addAttribute("name", "funder");
        p.setText("EC");
    }

    private void createHeader(Element profile) {
        Element header = profile.addElement("HEADER");
        Element rs = header.addElement("RESOURCE_IDENTIFIER");
        rs.addAttribute("value", "");
        Element rt = header.addElement("RESOURCE_TYPE");
        rt.addAttribute("value", "ContextDSResourceType");
        Element rk = header.addElement("RESOURCE_KIND");
        rk.addAttribute("value", "ContextDSResources");
        Element ru = header.addElement("RESOURCE_URI");
        ru.addAttribute("value", "");
        Element daoc = header.addElement("DATE_OF_CREATION");
        daoc.addAttribute("value", DateTime.now().toString());
    }

    private boolean parse(String project) throws VTDException, IOException {
        boolean fet = false;
        String callid = "";
        String projectid = "";
        VTDGen vg = new VTDGen();
        vg.setDoc(project.getBytes("UTF-8"));
        vg.parse(false);
        VTDNav vn = vg.getNav();
        AutoPilot ap = new AutoPilot(vn);
        ap.selectXPath("//metadata/ROWS/ROW[@table=\"projects\"]");
        while (ap.evalXPath() != -1) {
            AutoPilot ap1 = new AutoPilot(vn);
            ap1.selectXPath("./FIELD[@name=\"call_identifier\"]");
            if (ap1.evalXPath() != -1) {
                callid = vn.toNormalizedString(vn.getText());
            }
            ap1.clearVariableExprs();
            vn.toElement(1);
            ap1.selectXPath("./FIELD[@name=\"optional1\"]");
            if (ap1.evalXPath() != -1) {
                projectid = vn.toNormalizedString(vn.getText());
            }
            if (!callid.contains("FET")) continue;
            String type = callid.contains("OPEN") ? "OPEN" : (callid.contains("PROACT") ? "PROACT" : (callid.contains("HPC") ? "HPC" : "FLAG"));
            vn.toElement(0);
            fet = true;
            this.insert(type, callid, projectid, new Info(vn));
        }
        return fet;
    }

    private void insert(String type, String callid, String projcallid, Info row) {
        if (this.dic.containsKey(type)) {
            Map<String, Map<String, List<Info>>> dopen = this.dic.get(type);
            if (dopen.containsKey(callid)) {
                Map<String, List<Info>> entry = dopen.get(callid);
                if (entry.containsKey(projcallid)) {
                    entry.get(projcallid).add(row);
                } else {
                    ArrayList<Info> projects = new ArrayList<Info>();
                    projects.add(row);
                    entry.put(projcallid, projects);
                }
            } else {
                ArrayList<Info> projects = new ArrayList<Info>();
                HashMap<String, ArrayList<Info>> entry = new HashMap<String, ArrayList<Info>>();
                projects.add(row);
                entry.put(projcallid, projects);
                dopen.put(callid, entry);
            }
        } else {
            ArrayList<Info> projects = new ArrayList<Info>();
            HashMap<String, ArrayList<Info>> entry = new HashMap<String, ArrayList<Info>>();
            HashMap<String, HashMap<String, ArrayList<Info>>> dopen = new HashMap<String, HashMap<String, ArrayList<Info>>>();
            projects.add(row);
            entry.put(projcallid, projects);
            dopen.put(callid, entry);
            this.dic.put(type, dopen);
        }
    }

    public void parseFETProject(int projects_number) throws VTDException, IOException {
        int parsed = 0;
        while (this.projects.hasNext() && parsed < projects_number) {
            if (!this.parse(this.projects.next())) continue;
            ++parsed;
        }
        log.debug((Object)parsed);
    }

    private class Info {
        VTDNav vn;
        private String code;
        private String acronym;
        private String title;
        private String call_identifier;
        private String projcallid;
        private String callname;

        public String getCode() {
            return this.code;
        }

        public String getAcronym() {
            return this.acronym;
        }

        public String getTitle() {
            return this.title;
        }

        public String getCallID() {
            return this.call_identifier;
        }

        public String getProjcallid() {
            return this.projcallid;
        }

        public String getCallname() {
            return this.callname;
        }

        public Info(VTDNav vn) {
            this.vn = vn;
            this.parse();
        }

        private void parse() {
            try {
                AutoPilot ap = new AutoPilot(this.vn);
                ap.selectXPath("//FIELD");
                while (ap.evalXPath() != -1) {
                    String aname = this.vn.toNormalizedString(this.vn.getAttrVal("name"));
                    String text = "";
                    if (this.vn.getText() != -1) {
                        text = this.vn.toNormalizedString(this.vn.getText());
                    }
                    if (aname.equals("code")) {
                        this.code = text;
                        continue;
                    }
                    if (aname.equals("acronym")) {
                        this.acronym = text;
                        continue;
                    }
                    if (aname.equals("title")) {
                        this.title = text;
                        continue;
                    }
                    if (aname.equals("call_identifier")) {
                        this.call_identifier = text;
                        continue;
                    }
                    if (aname.equals("optional1")) {
                        this.projcallid = text;
                        continue;
                    }
                    if (!aname.equals("optional2")) continue;
                    this.callname = text;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

