/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.utils.ontologies;

import com.google.common.collect.Maps;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.utils.ontologies.Ontologies;
import eu.dnetlib.utils.ontologies.Ontology;
import eu.dnetlib.utils.ontologies.OntologyTerm;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;

@Component
public class OntologyLoader {
    private static final Log log = LogFactory.getLog(OntologyLoader.class);
    private static final String PATTERN = "classpath*:/eu/dnetlib/test/profiles/OntologyDSResources/OntologyDSResourceType/*.xml";
    private static UniqueServiceLocator staticServiceLocator;
    @Autowired
    private UniqueServiceLocator serviceLocator;

    public static String fetchInverse(String relType) throws ISLookUpException {
        String xquery = "let $x:= /RESOURCE_PROFILE[ .//RESOURCE_TYPE/@value = 'OntologyDSResourceType' and  .//TERM/@encoding='" + relType + "']let $y:= $x//TERM[./@encoding='" + relType + "']//RELATION[./@type='inverseOf']/@code/string() return $x//TERM[./@code = $y]/@encoding/string()";
        return ((ISLookUpService)staticServiceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(xquery);
    }

    @PostConstruct
    public void init() {
        staticServiceLocator = this.serviceLocator;
    }

    public static Ontology loadOntologyFromCp(InputStream profile) {
        return OntologyLoader.loadOntologyProfilefromPath(profile);
    }

    public static Ontologies loadOntologiesFromCp() throws IOException {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        List<InputStream> files = Arrays.asList(resolver.getResources(PATTERN)).stream().map(r -> {
            try {
                return r.getInputStream();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        return OntologyLoader.createOntologies(files);
    }

    public static Ontologies createOntologies(List<InputStream> files) {
        Ontologies ontologies = new Ontologies();
        files.stream().map(s -> OntologyLoader.loadOntologyProfilefromPath(s)).collect(Collectors.toMap(Ontology::getCode, Function.identity())).entrySet().forEach(it -> {
            Ontology cfr_ignored_0 = (Ontology)ontologies.put(it.getKey(), it.getValue());
        });
        return ontologies;
    }

    public static Ontologies loadOntologiesFromIS() throws ISLookUpException {
        ISLookUpService lookUpService = (ISLookUpService)staticServiceLocator.getService(ISLookUpService.class);
        List files = lookUpService.quickSearchProfile("for $x in collection('/db/DRIVER/OntologyDSResources/OntologyDSResourceType') return $x");
        Ontologies ontologies = new Ontologies();
        files.stream().map(OntologyLoader::getOntologyFromProfile).collect(Collectors.toMap(Ontology::getCode, Function.identity())).entrySet().forEach(it -> {
            Ontology cfr_ignored_0 = (Ontology)ontologies.put(it.getKey(), it.getValue());
        });
        return ontologies;
    }

    private static Ontology loadOntologyProfilefromPath(InputStream profile) {
        String profileXML;
        try {
            profileXML = IOUtils.toString((InputStream)profile);
        }
        catch (IOException e) {
            log.error((Object)e);
            return null;
        }
        return OntologyLoader.getOntologyFromProfile(profileXML);
    }

    private static Ontology getOntologyFromProfile(String profile) {
        SAXReader saxReader = new SAXReader();
        Document doc = null;
        StringReader reader = new StringReader(profile);
        try {
            doc = saxReader.read((Reader)reader);
        }
        catch (DocumentException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return new Ontology().setCode(doc.valueOf("//ONTOLOGY_NAME/@code")).setDescription(doc.valueOf("//ONTOLOGY_DESCRIPTION/text()")).setTerms(OntologyLoader.asTerms(doc.selectNodes("//TERMS/TERM")));
    }

    private static Map<String, OntologyTerm> asTerms(List list) {
        HashMap terms = Maps.newHashMap();
        if (list != null) {
            list.forEach(o -> {
                Element e = (Element)o;
                OntologyTerm ot = OntologyTerm.newInstance().setCode(e.attributeValue("code")).setEncoding(e.attributeValue("encoding")).setEnglishName(e.attributeValue("english_name")).setNativeName(e.attributeValue("native_name")).setInverseCode(((Node)o).valueOf("./RELATIONS/RELATION[@type = 'inverseOf']/@code"));
                terms.put(ot.getCode(), ot);
            });
        }
        return terms;
    }
}

