<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fn="http://www.w3.org/2005/xpath-functions" exclude-result-prefixes="fn">

	<xsl:variable name="namespacePrefix" select="string('ec__________')"/>
	<xsl:variable name="funderID" select="concat($namespacePrefix, '::EC')"/>

	<xsl:template match="/">
		<fundingtree>
			<funder>
				<id>
					<xsl:value-of select="$funderID"/>
				</id>
				<shortname>EC</shortname>
				<name>European Commission</name>
				<jurisdiction>EU</jurisdiction>
			</funder>
			<xsl:variable name="toaCode" select=".//ProjectTOACode"/>
			<xsl:choose>
				<xsl:when test="$toaCode and starts-with($toaCode, 'HORIZON-ERC')">
					<xsl:call-template name="ERC">
						<xsl:with-param name="toaCode" select="$toaCode"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$toaCode and not(starts-with($toaCode, 'HORIZON-ERC'))">
					<xsl:call-template name="other">
						<xsl:with-param name="toaCode" select="$toaCode"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="he"/>
				</xsl:otherwise>
			</xsl:choose>
		</fundingtree>
	</xsl:template>

	<xsl:template name="he">
		<funding_level_0>
			<id>
				<xsl:value-of select="concat($funderID, '::HE')"/>
			</id>
			<name>HE</name>
			<description>Horizon Europe Framework Programme</description>
			<parent/>
			<class>ec:hefundings</class>
		</funding_level_0>
	</xsl:template>

	<xsl:template name="ERC">
		<xsl:param name="toaCode"/>
		<xsl:variable name="toaId" select="concat($funderID, '::HE::ERC::', $toaCode)"/>
		<funding_level_2>
			<id>
				<xsl:value-of select="$toaId"/>
			</id>
			<description>
				<xsl:value-of select=".//ProjectTOADescr"/>
			</description>
			<name>
				<xsl:value-of select="$toaCode"/>
			</name>
			<class>ec:hetoas</class>
			<parent>
				<funding_level_1>
					<id>
						<xsl:value-of select="concat($funderID, '::HE::ERC')"/>
					</id>
					<description>
						<xsl:value-of select="string('European Research Council')"/>
					</description>
					<name>
						<xsl:value-of select="string('ERC')"/>
					</name>
					<class>ec:hefundings</class>
					<parent>
						<funding_level_0>
							<id>
								<xsl:value-of select="concat($funderID, '::HE')"/>
							</id>
							<name>HE</name>
							<description>Horizon Europe Framework Programme</description>
							<parent/>
							<class>ec:hefundings</class>
						</funding_level_0>
					</parent>
				</funding_level_1>
			</parent>
		</funding_level_2>
	</xsl:template>

	<xsl:template name="other">
		<xsl:param name="toaCode"/>
		<xsl:variable name="toaId" select="concat($funderID, '::HE::', $toaCode)"/>
		<funding_level_1>
			<id>
				<xsl:value-of select="$toaId"/>
			</id>
			<description>
				<xsl:value-of select=".//ProjectTOADescr"/>
			</description>
			<name>
				<xsl:value-of select="$toaCode"/>
			</name>
			<class>ec:hetoas</class>
			<parent>
				<funding_level_0>
					<id>
						<xsl:value-of select="concat($funderID, '::HE')"/>
					</id>
					<name>HE</name>
					<description>Horizon Europe Framework Programme</description>
					<parent/>
					<class>ec:hefundings</class>
				</funding_level_0>
			</parent>
		</funding_level_1>
	</xsl:template>
</xsl:stylesheet>
