<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:output indent="yes"/>
    <xsl:variable name="namespacePrefix" select="string('rif_________')"/>
    <xsl:variable name="funderID" select="concat($namespacePrefix, '::RIF')"/>
    <xsl:template match="/">
        <fundings>
            <fundingtree>
                <funder>
                    <id> <xsl:value-of select="$funderID"/></id>
                    <shortname>RIF</shortname>
                    <name>Research and Innovation Foundation</name>
                    <originalname>Research and Innovation Foundation</originalname>
                    <jurisdiction>CY</jurisdiction>
                </funder>
                <xsl:variable name="stream">
                    <xsl:value-of select="translate(.//column[@name = 'FUNDING STREAM'],' ','')"/>
                </xsl:variable>
                <funding_level_0>
                    <id>
                        <xsl:value-of select="concat($funderID, '::',$stream)"/>
                    </id>
                    <name><xsl:value-of select=".//column[@name='FUNDING STREAM']"/></name>
                    <description><xsl:value-of select=".//column[@name='FUNDING STREAM']"/></description>
                    <parent/>
                    <class>
                        <xsl:value-of select="concat('rif:',lower-case($stream),'fundings')"/>
                    </class>
                </funding_level_0>
            </fundingtree>
        </fundings>
    </xsl:template>
</xsl:stylesheet>