/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.clustering;

import com.google.common.collect.Lists;
import eu.dnetlib.pace.clustering.AbstractClusteringFunction;
import eu.dnetlib.pace.clustering.ClusteringClass;
import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.Person;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@ClusteringClass(value="lnfi")
public class LastNameFirstInitial
extends AbstractClusteringFunction {
    private boolean DEFAULT_AGGRESSIVE = true;

    public LastNameFirstInitial(Map<String, Integer> params) {
        super(params);
    }

    @Override
    public Collection<String> apply(Config conf, List<Field> fields) {
        return fields.stream().filter(f -> !f.isEmpty()).map(Field::stringValue).map(this::normalize).map(s -> this.doApply(conf, (String)s)).map(c -> this.filterBlacklisted((Collection<String>)c, ngramBlacklist)).flatMap(c -> c.stream()).filter(StringUtils::isNotBlank).collect(Collectors.toCollection(HashSet::new));
    }

    @Override
    protected String normalize(String s) {
        return LastNameFirstInitial.fixAliases(LastNameFirstInitial.transliterate(this.nfd(this.unicodeNormalization(s)))).replaceAll("[^ \\w]+", "").replaceAll("(\\p{InCombiningDiacriticalMarks})+", "").replaceAll("(\\p{Punct})+", " ").replaceAll("(\\d)+", " ").replaceAll("(\\n)+", " ").trim();
    }

    @Override
    protected Collection<String> doApply(Config conf, String s) {
        ArrayList res = Lists.newArrayList();
        boolean aggressive = (Boolean)(this.getParams().containsKey("aggressive") ? (Serializable)this.getParams().get("aggressive") : Boolean.valueOf(this.DEFAULT_AGGRESSIVE));
        Person p = new Person(s, aggressive);
        if (p.isAccurate()) {
            String lastName = p.getNormalisedSurname().toLowerCase();
            String firstInitial = p.getNormalisedFirstName().toLowerCase().substring(0, 1);
            res.add(firstInitial.concat(lastName));
        } else {
            List<String> fullname = Arrays.asList(p.getNormalisedFullname().split(" "));
            if (fullname.size() == 1) {
                res.add(p.getNormalisedFullname().toLowerCase());
            } else if (fullname.size() == 2) {
                res.add(fullname.get(0).substring(0, 1).concat(fullname.get(1)).toLowerCase());
                res.add(fullname.get(1).substring(0, 1).concat(fullname.get(0)).toLowerCase());
            } else {
                res.add(fullname.get(0).substring(0, 1).concat(fullname.get(fullname.size() - 1)).toLowerCase());
                res.add(fullname.get(fullname.size() - 1).substring(0, 1).concat(fullname.get(0)).toLowerCase());
            }
        }
        return res;
    }
}

