/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.clustering;

import com.google.common.collect.Sets;
import eu.dnetlib.pace.clustering.AbstractClusteringFunction;
import eu.dnetlib.pace.clustering.ClusteringClass;
import eu.dnetlib.pace.config.Config;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@ClusteringClass(value="wordsStatsSuffixPrefixChain")
public class WordsStatsSuffixPrefixChain
extends AbstractClusteringFunction {
    public WordsStatsSuffixPrefixChain(Map<String, Integer> params) {
        super(params);
    }

    @Override
    protected Collection<String> doApply(Config conf, String s) {
        return this.suffixPrefixChain(s, this.param("mod"));
    }

    private Collection<String> suffixPrefixChain(String s, int mod) {
        List<String> wordsList = Arrays.stream(s.split(" ")).filter(si -> si.length() > 3).collect(Collectors.toList());
        int words = wordsList.size();
        int letters = s.length();
        String prefix = words + "-" + letters / mod + "-";
        return this.doSuffixPrefixChain(wordsList, prefix);
    }

    private Collection<String> doSuffixPrefixChain(List<String> wordsList, String prefix) {
        LinkedHashSet set = Sets.newLinkedHashSet();
        switch (wordsList.size()) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                set.add(prefix + this.suffix(wordsList.get(0), 3) + this.prefix(wordsList.get(1), 3));
                set.add(prefix + this.prefix(wordsList.get(0), 3) + this.suffix(wordsList.get(1), 3));
                break;
            }
            default: {
                set.add(prefix + this.suffix(wordsList.get(0), 3) + this.prefix(wordsList.get(1), 3) + this.suffix(wordsList.get(2), 3));
                set.add(prefix + this.prefix(wordsList.get(0), 3) + this.suffix(wordsList.get(1), 3) + this.prefix(wordsList.get(2), 3));
            }
        }
        return set;
    }

    private String suffix(String s, int len) {
        return s.substring(s.length() - len);
    }

    private String prefix(String s, int len) {
        return s.substring(0, len);
    }
}

