/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.tree;

import com.google.common.collect.Sets;
import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldList;
import eu.dnetlib.pace.tree.support.AbstractComparator;
import eu.dnetlib.pace.tree.support.ComparatorClass;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@ComparatorClass(value="instanceTypeMatch")
public class InstanceTypeMatch
extends AbstractComparator {
    final Map<String, String> translationMap = new HashMap<String, String>();

    public InstanceTypeMatch(Map<String, String> params) {
        super(params);
        this.translationMap.put("Conference object", "*");
        this.translationMap.put("Other literature type", "*");
        this.translationMap.put("Unknown", "*");
        this.translationMap.put("Article", "Article");
        this.translationMap.put("Data Paper", "Article");
        this.translationMap.put("Software Paper", "Article");
        this.translationMap.put("Preprint", "Article");
        this.translationMap.put("Thesis", "Thesis");
        this.translationMap.put("Master thesis", "Thesis");
        this.translationMap.put("Bachelor thesis", "Thesis");
        this.translationMap.put("Doctoral thesis", "Thesis");
    }

    @Override
    public double compare(Field a, Field b, Config conf) {
        if (a == null || b == null) {
            return -1.0;
        }
        List<String> sa = ((FieldList)a).stringList();
        List<String> sb = ((FieldList)b).stringList();
        if (sa.isEmpty() || sb.isEmpty()) {
            return -1.0;
        }
        Set ca = sa.stream().map(this::translate).collect(Collectors.toSet());
        Set cb = sb.stream().map(this::translate).collect(Collectors.toSet());
        if (ca.contains("*") || cb.contains("*")) {
            return 1.0;
        }
        int incommon = Sets.intersection(ca, cb).size();
        return incommon >= 1 ? 1.0 : 0.0;
    }

    public String translate(String term) {
        return this.translationMap.getOrDefault(term, term);
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    protected double normalize(double d) {
        return d;
    }
}

