/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import eu.dnetlib.pace.config.DedupConfig;
import eu.dnetlib.pace.config.Type;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldListImpl;
import eu.dnetlib.pace.model.FieldValueImpl;
import eu.dnetlib.pace.model.MapDocument;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minidev.json.JSONArray;

public class MapDocumentUtil {
    public static final String URL_REGEX = "^(http|https|ftp)\\://.*";
    public static Predicate<String> urlFilter = s -> s.trim().matches(URL_REGEX);

    public static MapDocument asMapDocumentWithJPath(DedupConfig conf, String json) {
        MapDocument m = new MapDocument();
        m.setIdentifier(MapDocumentUtil.getJPathString(conf.getWf().getIdPath(), json));
        HashMap<String, Field> stringField = new HashMap<String, Field>();
        conf.getPace().getModel().forEach(fdef -> {
            switch (fdef.getType()) {
                case String: 
                case Int: {
                    stringField.put(fdef.getName(), new FieldValueImpl(fdef.getType(), fdef.getName(), MapDocumentUtil.truncateValue(MapDocumentUtil.getJPathString(fdef.getPath(), json), fdef.getLength())));
                    break;
                }
                case URL: {
                    String uv = MapDocumentUtil.getJPathString(fdef.getPath(), json);
                    if (!urlFilter.test(uv)) {
                        uv = "";
                    }
                    stringField.put(fdef.getName(), new FieldValueImpl(fdef.getType(), fdef.getName(), uv));
                    break;
                }
                case List: 
                case JSON: {
                    FieldListImpl fi = new FieldListImpl(fdef.getName(), fdef.getType());
                    MapDocumentUtil.truncateList(MapDocumentUtil.getJPathList(fdef.getPath(), json, fdef.getType()), fdef.getSize()).stream().map(item -> new FieldValueImpl(Type.String, fdef.getName(), item)).forEach(fi::add);
                    stringField.put(fdef.getName(), fi);
                    break;
                }
                case DoubleArray: {
                    stringField.put(fdef.getName(), new FieldValueImpl(Type.DoubleArray, fdef.getName(), MapDocumentUtil.getJPathArray(fdef.getPath(), json)));
                    break;
                }
                case StringConcat: {
                    String[] jpaths = fdef.getPath().split("\\|\\|\\|");
                    stringField.put(fdef.getName(), new FieldValueImpl(Type.String, fdef.getName(), MapDocumentUtil.truncateValue(Arrays.stream(jpaths).map(jpath -> MapDocumentUtil.getJPathString(jpath, json)).collect(Collectors.joining(" ")), fdef.getLength())));
                }
            }
        });
        m.setFieldMap(stringField);
        return m;
    }

    public static List<String> getJPathList(String path, String json, Type type) {
        Object jresult;
        if (type == Type.List) {
            return (List)JsonPath.using((Configuration)Configuration.defaultConfiguration().addOptions(new Option[]{Option.ALWAYS_RETURN_LIST, Option.SUPPRESS_EXCEPTIONS})).parse(json).read(path, new com.jayway.jsonpath.Predicate[0]);
        }
        ArrayList<String> result = new ArrayList<String>();
        try {
            jresult = JsonPath.read((String)json, (String)path, (com.jayway.jsonpath.Predicate[])new com.jayway.jsonpath.Predicate[0]);
        }
        catch (Throwable e) {
            return result;
        }
        if (jresult instanceof JSONArray) {
            ((JSONArray)jresult).forEach(it -> {
                try {
                    result.add(new ObjectMapper().writeValueAsString(it));
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
            });
            return result;
        }
        if (jresult instanceof LinkedHashMap) {
            try {
                result.add(new ObjectMapper().writeValueAsString(jresult));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            return result;
        }
        if (jresult instanceof String) {
            result.add((String)jresult);
        }
        return result;
    }

    public static String getJPathString(String jsonPath, String json) {
        try {
            Object o = JsonPath.read((String)json, (String)jsonPath, (com.jayway.jsonpath.Predicate[])new com.jayway.jsonpath.Predicate[0]);
            if (o instanceof String) {
                return (String)o;
            }
            if (o instanceof JSONArray && ((JSONArray)o).size() > 0) {
                return (String)((JSONArray)o).get(0);
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public static double[] getJPathArray(String jsonPath, String json) {
        try {
            Object o = JsonPath.read((String)json, (String)jsonPath, (com.jayway.jsonpath.Predicate[])new com.jayway.jsonpath.Predicate[0]);
            if (o instanceof double[]) {
                return (double[])o;
            }
            if (o instanceof JSONArray) {
                Object[] objects = ((JSONArray)o).toArray();
                double[] array = new double[objects.length];
                for (int i = 0; i < objects.length; ++i) {
                    array[i] = objects[i] instanceof BigDecimal ? ((BigDecimal)objects[i]).doubleValue() : ((Double)objects[i]).doubleValue();
                }
                return array;
            }
            return new double[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return new double[0];
        }
    }

    public static String truncateValue(String value, int length) {
        if (value == null) {
            return "";
        }
        if (length == -1 || length > value.length()) {
            return value;
        }
        return value.substring(0, length);
    }

    public static List<String> truncateList(List<String> list, int size) {
        if (size == -1 || size > list.size()) {
            return list;
        }
        return list.subList(0, size);
    }
}

