/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.clustering;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import eu.dnetlib.pace.clustering.AbstractClusteringFunction;
import eu.dnetlib.pace.clustering.ClusteringClass;
import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.model.Field;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@ClusteringClass(value="lowercase")
public class LowercaseClustering
extends AbstractClusteringFunction {
    public LowercaseClustering(Map<String, Integer> params) {
        super(params);
    }

    @Override
    public Collection<String> apply(Config conf, List<Field> fields) {
        LinkedHashSet c = Sets.newLinkedHashSet();
        for (Field f : fields) {
            c.addAll(this.doApply(conf, f.stringValue()));
        }
        return c;
    }

    @Override
    protected Collection<String> doApply(Config conf, String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Object[])new String[]{s.toLowerCase().trim()});
    }
}

