/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.clustering;

import com.google.common.collect.Sets;
import eu.dnetlib.pace.clustering.ClusteringClass;
import eu.dnetlib.pace.clustering.ClusteringFunction;
import eu.dnetlib.pace.common.AbstractPaceFunctions;
import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.Person;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@ClusteringClass(value="personClustering")
public class PersonClustering
extends AbstractPaceFunctions
implements ClusteringFunction {
    private Map<String, Integer> params;
    private static final int MAX_TOKENS = 5;

    public PersonClustering(Map<String, Integer> params) {
        this.params = params;
    }

    @Override
    public Collection<String> apply(Config conf, List<Field> fields) {
        HashSet hashes = Sets.newHashSet();
        for (Field f : fields) {
            Person person = new Person(f.stringValue(), false);
            if (StringUtils.isNotBlank((CharSequence)person.getNormalisedFirstName()) && StringUtils.isNotBlank((CharSequence)person.getNormalisedSurname())) {
                hashes.add(this.firstLC(person.getNormalisedFirstName()) + person.getNormalisedSurname().toLowerCase());
                continue;
            }
            for (String token1 : this.tokens(f.stringValue(), 5)) {
                for (String token2 : this.tokens(f.stringValue(), 5)) {
                    if (token1.equals(token2)) continue;
                    hashes.add(this.firstLC(token1) + token2);
                }
            }
        }
        return hashes;
    }

    @Override
    public Map<String, Integer> getParams() {
        return this.params;
    }
}

