/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.tree.support;

import com.wcohen.ss.AbstractStringDistance;
import eu.dnetlib.pace.common.AbstractPaceFunctions;
import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.config.Type;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldList;
import eu.dnetlib.pace.tree.support.Comparator;
import java.util.List;
import java.util.Map;

public abstract class AbstractComparator
extends AbstractPaceFunctions
implements Comparator {
    protected AbstractStringDistance ssalgo;
    protected double weight = 0.0;
    private Map<String, String> params;

    protected AbstractComparator(Map<String, String> params) {
        this.params = params;
    }

    protected AbstractComparator(Map<String, String> params, AbstractStringDistance ssalgo) {
        this.params = params;
        this.weight = 1.0;
        this.ssalgo = ssalgo;
    }

    protected AbstractComparator(double weight, AbstractStringDistance ssalgo) {
        this.ssalgo = ssalgo;
        this.weight = weight;
    }

    protected AbstractComparator(AbstractStringDistance ssalgo) {
        this.ssalgo = ssalgo;
    }

    protected double normalize(double d) {
        return d;
    }

    public double distance(String a, String b, Config conf) {
        if (a.isEmpty() || b.isEmpty()) {
            return -1.0;
        }
        double score = this.ssalgo.score(a, b);
        return this.normalize(score);
    }

    protected double distance(List<String> a, List<String> b, Config conf) {
        return this.distance(this.concat(a), this.concat(b), conf);
    }

    public double distance(Field a, Field b, Config conf) {
        if (a.getType().equals((Object)Type.String) && b.getType().equals((Object)Type.String)) {
            return this.distance(a.stringValue(), b.stringValue(), conf);
        }
        if (a.getType().equals((Object)Type.List) && b.getType().equals((Object)Type.List)) {
            return this.distance(this.toList(a), this.toList(b), conf);
        }
        throw new IllegalArgumentException("invalid types\n- A: " + a.toString() + "\n- B: " + b.toString());
    }

    @Override
    public double compare(Field a, Field b, Config conf) {
        if (a.isEmpty() || b.isEmpty()) {
            return -1.0;
        }
        if (a.getType().equals((Object)Type.String) && b.getType().equals((Object)Type.String)) {
            return this.distance(a.stringValue(), b.stringValue(), conf);
        }
        if (a.getType().equals((Object)Type.List) && b.getType().equals((Object)Type.List)) {
            return this.distance(this.toList(a), this.toList(b), conf);
        }
        throw new IllegalArgumentException("invalid types\n- A: " + a.toString() + "\n- B: " + b.toString());
    }

    protected List<String> toList(Field list) {
        return ((FieldList)list).stringList();
    }

    public double getWeight() {
        return this.weight;
    }
}

