package eu.dnetlib.msro.workflows.nodes.validation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.datasources.common.Api;
import eu.dnetlib.enabling.datasources.common.Datasource;
import eu.dnetlib.enabling.datasources.common.LocalDatasourceManager;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;

public class SetInfoForValidationJobNode extends SimpleJobNode {

	public static final Log log = LogFactory.getLog(SetInfoForValidationJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Autowired
	private LocalDatasourceManager<Datasource<?, ?, ?>, Api<?>> dsManager;

	private String profileId;
	private String providerName;
	private String api;

	@Override
	protected String execute(final NodeToken token) throws Exception {

		final String dsId = getProfileId();
		final String nsPrefix = dsManager.getDs(dsId).getNamespaceprefix();
		final String interfaceURL = dsManager.getApis(dsId)
			.stream()
			.filter(a -> a.getId().equals(getApi()))
			.map(a -> a.getBaseurl())
			.findFirst()
			.orElse("");

		token.getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_ID, dsId);
		token.getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_ORIGINALID, dsId);
		token.getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_NAME, getProviderName());
		token.getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_INTERFACE, getApi());
		token.getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_NAMESPACE_PREFIX, nsPrefix);
		token.getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_INTERFACE_BASEURL, interfaceURL);

		token.getFullEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_ID, dsId);
		token.getFullEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_ORIGINALID, dsId);
		token.getFullEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_NAME, getProviderName());
		token.getFullEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_INTERFACE, getApi());
		token.getFullEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_NAMESPACE_PREFIX, nsPrefix);
		token.getFullEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_INTERFACE_BASEURL, interfaceURL);

		token.getProcess().getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_ID, dsId);
		token.getProcess().getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_ORIGINALID, dsId);
		token.getProcess().getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_NAME, getProviderName());
		token.getProcess().getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_INTERFACE, getApi());
		token.getProcess().getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_NAMESPACE_PREFIX, nsPrefix);
		token.getProcess().getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_INTERFACE_BASEURL, interfaceURL);

		return Arc.DEFAULT_ARC;
	}

	public String getProviderName() {
		return providerName;
	}

	public void setProviderName(final String providerName) {
		this.providerName = providerName;
	}

	public String getApi() {
		return api;
	}

	public void setApi(final String api) {
		this.api = api;
	}

	public String getProfileId() {
		return profileId;
	}

	public void setProfileId(final String profileId) {
		this.profileId = profileId;
	}
}
