<NODE name="SET_INFO_VALIDATION" isStart="true" type="SetInfoForValidation">
	<DESCRIPTION>Retrieve information about current Content Provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="profileId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
		<PARAM required="true" type="string" name="api" managedBy="system">$params.("dataprovider:interface")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="selectValidate"/>
	</ARCS>
</NODE>
<NODE name="selectValidate" type="Selection">
	<DESCRIPTION>Do we validate the records?</DESCRIPTION>
	<PARAMETERS>
		<PARAM function="validValues(['YES', 'NO'])" managedBy="user" name="selection" required="true" type="string">YES</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC name="YES" to="validate" />
		<ARC name="NO" to="success" />
	</ARCS>
</NODE>
<NODE name="validate" type="ValidationAsStep">
	<DESCRIPTION>Validate from mdStore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="boolean" name="shouldOutputRecords" managedBy="system">false</PARAM>
            <PARAM required="false" type="string" name="outputEprName" managedBy="system">validatorEpr</PARAM>
            <PARAM required="true" type="string" name="mdstoreId" managedBy="system" category="MDSTORE_ID">$params.("coll_id")$</PARAM>
            <PARAM required="true" type="string" name="xQueryForValidatorServiceId" managedBy="user">/RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='ValidatorServiceResourceType' and .//RESOURCE_KIND/@value='ServiceResources']/HEADER/RESOURCE_IDENTIFIER/@value/string()</PARAM>
            <PARAM required="false" type="string" name="recordsSampleSize" managedBy="user">ALL</PARAM>
            <PARAM required="true" type="string" name="guidelines" managedBy="user" function="validValues(['openaire3.0', 'openaire2.0', 'openaire2.0_data', 'driver'])"/>
            <PARAM required="true" type="boolean" name="shouldUpdateBlacklist" managedBy="user">true</PARAM>
            <PARAM managedBy="user" name="blacklistRuleName" required="false" type="string">blacklist_rules</PARAM>
            <PARAM required="false" type="int" name="jobStatusUpdateInterval" managedBy="system"/>
            <PARAM required="false" type="string" name="extraParams" managedBy="user"/>
	</PARAMETERS>
	<ARCS>
		<ARC to="storeRecords"/>
	</ARCS>
</NODE>
<NODE name="storeRecords" type="StoreMDStoreRecords">
	<DESCRIPTION>Store records into mdstore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system" category="MDSTORE_ID">$params.("val_id")$</PARAM>
		<PARAM required="true" type="string" name="storingType" managedBy="user" function="validValues(['REFRESH', 'INCREMENTAL'])"/>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">validatorEpr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="success"/>
	</ARCS>
</NODE>
