/**
 *
 */
package eu.dnetlib.data.collective.transformation.engine.functions;

import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.text.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.xml.sax.InputSource;

import eu.dnetlib.common.profile.Resource;
import eu.dnetlib.common.profile.ResourceDao;
import eu.dnetlib.data.collective.transformation.rulelanguage.Argument;
import eu.dnetlib.enabling.datasources.common.Api;
import eu.dnetlib.enabling.datasources.common.Datasource;
import eu.dnetlib.enabling.datasources.common.DsmException;
import eu.dnetlib.enabling.datasources.common.LocalDatasourceManager;

/**
 * @author jochen
 *
 */
public class RetrieveValue extends AbstractTransformationFunction {

	public static final Log log = LogFactory.getLog(RetrieveValue.class);
	public static final String paramFunctionName = "functionName";
	public static final String paramFunctionProfileId = "functionParameterProfileId";
	public static final String paramFunctionExpr = "functionParameterExpr";

	public enum FUNCTION {
		PROFILEFIELD,
		CURRENTDATE,
		DSFIELDBYPREFIX
	};

	@Autowired
	private ResourceDao resourceDao;

	@Autowired
	private LocalDatasourceManager<Datasource<?, ?, ?>, Api<?>> dsManager;

	/*
	 * (non-Javadoc)
	 *
	 * @see eu.dnetlib.data.collective.transformation.engine.functions.AbstractTransformationFunction#execute()
	 */
	@Override
	String execute() throws ProcessingException {
		// TODO Auto-generated method stub
		return null;
	}

	public String executeSingleValue(final String functionName, final List<Argument> arguments, final String objRecord, final Map<String, String> namespaceMap)
		throws ProcessingException {

		String result = "";
		final FUNCTION function = FUNCTION.valueOf(functionName);

		switch (function) {
		case DSFIELDBYPREFIX:
			if (arguments.size() != 2) {
				throw new ProcessingException("DSFIELDBYPREFIX: invalid number of arguments - required 2 but found :" + arguments.size());
			}

			final String prefix = evaluateXpath(objRecord, arguments.get(0).getArgument(), namespaceMap);
			final String field = StringEscapeUtils.unescapeXml(arguments.get(1).getArgument());

			log.debug("DSFIELDBYPREFIX - prefix: " + prefix);
			log.debug("DSFIELDBYPREFIX - field: " + field);

			try {
				final Datasource<?, ?, ?> ds = dsManager.getDsByNsPrefix(prefix);
				if (field.equalsIgnoreCase("id")) {
					result = ds.getId();
				} else if (field.equalsIgnoreCase("nsprefix")) {
					result = ds.getNamespaceprefix();
				} else if (field.equalsIgnoreCase("officialname")) {
					result = ds.getOfficialname();
				} else if (field.equalsIgnoreCase("type")) {
					result = ds.getEoscDatasourceType();
				} else if (field.equalsIgnoreCase("webpage")) {
					result = ds.getWebsiteurl();
				} else if (field.equalsIgnoreCase("country")) {
					result = ds.getOrganizations().stream().map(o -> o.getCountry()).filter(StringUtils::isNotBlank).findFirst().orElse("");
				} else if (field.equalsIgnoreCase("institution")) {
					result = ds.getOrganizations().stream().map(o -> o.getLegalname()).filter(StringUtils::isNotBlank).findFirst().orElse("");
				} else {
					log.error("DSFIELDBYPREFIX: field not supported: " + field);
					throw new ProcessingException("DSFIELDBYPREFIX: field not supported: " + field);
				}
			} catch (final DsmException e) {
				log.error("DSFIELDBYPREFIX: datasource not found, prefix: " + prefix, e);
				throw new ProcessingException("DSFIELDBYPREFIX: datasource not found, prefix: " + prefix, e);
			}

			log.debug("DSFIELDBYPREFIX - result: " + result);

			break;
		case PROFILEFIELD:
			if (arguments.size() != 2) {
				throw new ProcessingException("PROFILEFIELD: invalid number of arguments - required 2 but found :" + arguments.size());
			}

			String arg = "";
			Resource resource = null;
			try {
				if (arguments.get(0).isValue()) {
					arg = arguments.get(0).getArgument();
					log.debug("retrieve value arg isValue: " + arg);
					if (arg.startsWith("collection(")) { // xquery
						arg = StringEscapeUtils.unescapeXml(arg);
						resource = resourceDao.getResourceByQuery(arg); // query
					} else {
						resource = resourceDao.getResource(arg); // profile id
					}
				} else if (arguments.get(0).isInputField()) {
					arg = evaluateXpath(objRecord, arguments.get(0).getArgument(), namespaceMap);
					log.debug("retrieve value arg isInputField: " + arg);
					if (arg.startsWith("collection(")) { // xquery
						arg = StringEscapeUtils.unescapeXml(arg);
						resource = resourceDao.getResourceByQuery(arg); // query
					} else {
						resource = resourceDao.getResource(arg); // profile id
					}
				} else if (arguments.get(0).isJobConst()) {
					// TODO
				} else if (arguments.get(0).isVariable()) {
					// TODO
					log.warn("RETRIEVEVALUE: support for variables not yet implemented.");
				}
			} catch (final Exception e) {
				throw new ProcessingException(e);
			}

			if (resource == null) {
				throw new ProcessingException("invalid profileId: " + arg + "; functionName: " + functionName + ", arg1: " + arguments.get(0).getArgument()
					+ ", arg2: " + arguments.get(1).getArgument());
			}
			result = resource.getValue(arguments.get(1).getArgument());  // xpath expr
			break;
		case CURRENTDATE:
			final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'"); // TODO format string
			result = dateFormat.format(new Date());
		default:
			// unsupported
			break;
		}

		return result;
	}

	/**
	 * @return the resourceDao
	 */
	public ResourceDao getResourceDao() {
		return resourceDao;
	}

	/**
	 * @param resourceDao
	 *            the resourceDao to set
	 */
	public void setResourceDao(final ResourceDao resourceDao) {
		this.resourceDao = resourceDao;
	}

	private String evaluateXpath(final String record, final String xpathExpr, final Map<String, String> nsMap) {
		final XPath xpath = XPathFactory.newInstance().newXPath();
		xpath.setNamespaceContext(new NamespaceContext() {

			@Override
			public Iterator getPrefixes(final String namespaceURI) {
				return null;
			}

			@Override
			public String getPrefix(final String namespaceURI) {
				// TODO Auto-generated method stub
				return null;
			}

			@Override
			public String getNamespaceURI(final String prefix) {
				if ("dri".equals(prefix)) {
					return "http://www.driver-repository.eu/namespace/dri";
				} else if ("dr".equals(prefix)) {
					return "http://www.driver-repository.eu/namespace/dr";
				} else if ("dc".equals(prefix)) {
					return "http://purl.org/dc/elements/1.1/";
				} else if ("oaf".equals(prefix)) {
					return "http://namespace.openaire.eu/oaf";
				} else if ("prov".equals(prefix)) { return "http://www.openarchives.org/OAI/2.0/provenance"; }
				return "";
			}
		});
		try {
			return xpath.evaluate(xpathExpr, new InputSource(new StringReader(record)));
		} catch (final XPathExpressionException e) {
			log.fatal("cannot evaluate xpath");
			throw new IllegalStateException(e);
		}
	}

	public LocalDatasourceManager<Datasource<?, ?, ?>, Api<?>> getDsManager() {
		return dsManager;
	}

	public void setDsManager(final LocalDatasourceManager<Datasource<?, ?, ?>, Api<?>> dsManager) {
		this.dsManager = dsManager;
	}
}
