package eu.dnetlib.openaire.user.login.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.nimbusds.jwt.JWTClaimsSet;
import eu.dnetlib.openaire.user.login.authorization.OpenAIREAuthoritiesMapper;
import org.apache.log4j.Logger;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

import java.text.ParseException;
import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AuthoritiesMapper {

    private static final Logger logger = Logger.getLogger(AuthoritiesMapper.class);

    public static Collection<? extends GrantedAuthority> map(JsonArray entitlements) {
        HashSet<SimpleGrantedAuthority> authorities = new HashSet<>();
        logger.info("entitlements" + entitlements.size());
        String  regex = "urn:geant:openaire[.]eu:group:(\\w+[\\W]*\\w+[-\\w]*):?(.*)?:role=member#aai[.]openaire[.]eu";
        authorities.add(new SimpleGrantedAuthority("REGISTERED_USER"));
        for(JsonElement obj: entitlements) {
            Matcher matcher = Pattern.compile(regex).matcher(obj.getAsString());
            if (matcher.find()) {
                StringBuilder sb = new StringBuilder();
                if(matcher.group(1) != null && matcher.group(1).length() > 0) {
                    sb.append(matcher.group(1).replaceFirst("[\\W]+", "_").toUpperCase());
                }
                if(matcher.group(2).length() > 0) {
                    if(sb.toString().length() > 0) {
                        sb.append("_");
                    }
                    if(matcher.group(2).equals("admins")) {
                        sb.append("MANAGER");
                    } else  {
                        sb.append(matcher.group(2).toUpperCase());
                    }
                }
                authorities.add(new SimpleGrantedAuthority
                        (sb.toString()));
            }
        }
        return authorities;
    }
}
