/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.user.login.utils;

import com.google.gson.JsonObject;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.Date;
import org.apache.log4j.Logger;
import org.mitre.openid.connect.model.OIDCAuthenticationToken;
import org.mitre.openid.connect.model.UserInfo;

public class JWTGenerator {
    private static final Logger logger = Logger.getLogger(JWTGenerator.class);

    public static String generateToken(OIDCAuthenticationToken authOIDC, String secret) {
        try {
            JsonObject userInfo = authOIDC.getUserInfo().getSource();
            Claims claims = Jwts.claims().setSubject(authOIDC.getUserInfo().getSub());
            claims.put((Object)"fullname", (Object)(URLEncoder.encode(authOIDC.getUserInfo().getName(), "UTF-8") + ""));
            if (authOIDC.getUserInfo().getGivenName() == null) {
                logger.info((Object)("User: " + authOIDC.getUserInfo().getName() + "doesn't have first name"));
                claims.put((Object)"firstname", (Object)(URLEncoder.encode(" ", "UTF-8") + ""));
            } else {
                claims.put((Object)"firstname", (Object)(URLEncoder.encode(authOIDC.getUserInfo().getGivenName(), "UTF-8") + ""));
            }
            if (authOIDC.getUserInfo().getFamilyName() == null) {
                logger.info((Object)("User: " + authOIDC.getUserInfo().getName() + "doesn't have first name"));
                claims.put((Object)"lastname", (Object)(URLEncoder.encode(" ", "UTF-8") + ""));
            } else {
                claims.put((Object)"lastname", (Object)(URLEncoder.encode(authOIDC.getUserInfo().getFamilyName(), "UTF-8") + ""));
            }
            claims.put((Object)"email", (Object)(authOIDC.getUserInfo().getEmail() + ""));
            if (userInfo.getAsJsonArray("edu_person_entitlements") == null) {
                logger.info((Object)("User: " + authOIDC.getUserInfo().getName() + "doesn't have role"));
                claims.put((Object)"role", (Object)(URLEncoder.encode(" ", "UTF-8") + ""));
            } else {
                claims.put((Object)"role", (Object)(URLEncoder.encode(userInfo.getAsJsonArray("edu_person_entitlements").toString(), "UTF-8") + ""));
            }
            Date exp = new Date(authOIDC.getIdToken().getJWTClaimsSet().getExpirationTime().getTime());
            return Jwts.builder().setClaims(claims).setExpiration(exp).signWith(SignatureAlgorithm.HS512, secret).compact();
        }
        catch (ParseException e) {
            e.printStackTrace();
            logger.error((Object)"JWT Parse Exception from getting Expiration Time ", (Throwable)e);
            return "error";
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            logger.error((Object)"UnsupportedEncodingException UTF-8 ", (Throwable)e);
            return "error";
        }
    }

    public static JsonObject generateJsonToken(OIDCAuthenticationToken authOIDC) {
        try {
            JsonObject userInfo = authOIDC.getUserInfo().getSource();
            JsonObject userInfo2 = new JsonObject();
            if (authOIDC.getUserInfo().getSub() == null) {
                logger.info((Object)"User doesn't have sub");
                userInfo2.addProperty("sub", "");
            } else {
                userInfo2.addProperty("sub", URLEncoder.encode(authOIDC.getUserInfo().getSub(), "UTF-8"));
            }
            if (authOIDC.getUserInfo().getName() == null) {
                logger.info((Object)"User doesn't have fullname");
                userInfo2.addProperty("fullname", "");
            } else {
                userInfo2.addProperty("fullname", URLEncoder.encode(authOIDC.getUserInfo().getName(), "UTF-8"));
            }
            if (authOIDC.getUserInfo().getGivenName() == null) {
                logger.info((Object)("User: " + authOIDC.getUserInfo().getName() + "doesn't have first name"));
                userInfo2.addProperty("firstname", "");
            } else {
                userInfo2.addProperty("firstname", URLEncoder.encode(authOIDC.getUserInfo().getGivenName(), "UTF-8") + "");
            }
            if (authOIDC.getUserInfo().getFamilyName() == null) {
                logger.info((Object)("User: " + authOIDC.getUserInfo().getName() + "doesn't have first name"));
                userInfo2.addProperty("lastname", "");
            } else {
                userInfo2.addProperty("lastname", URLEncoder.encode(authOIDC.getUserInfo().getFamilyName(), "UTF-8") + "");
            }
            userInfo2.addProperty("email", authOIDC.getUserInfo().getEmail() + "");
            if (userInfo.getAsJsonArray("edu_person_entitlements") == null) {
                logger.info((Object)("User: " + authOIDC.getUserInfo().getName() + "doesn't have role"));
                userInfo2.addProperty("role", "");
            } else {
                userInfo2.addProperty("role", URLEncoder.encode(userInfo.getAsJsonArray("edu_person_entitlements").toString(), "UTF-8") + "");
            }
            logger.info((Object)("UserINFO: " + userInfo2.toString()));
            return userInfo2;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            logger.error((Object)"UnsupportedEncodingException UTF-8 ", (Throwable)e);
            JsonObject error = new JsonObject();
            error.addProperty("error", "UnsupportedEncodingException UTF-8 " + e);
            return error;
        }
    }

    public static String generateAccessToken(OIDCAuthenticationToken authOIDC, String secret) {
        Claims claims = Jwts.claims().setId(authOIDC.getAccessTokenValue());
        logger.info((Object)"\n////////////////////////////////////////////////////////////////////////////////////////////////\n");
        logger.info((Object)("access token: " + authOIDC.getAccessTokenValue()));
        logger.info((Object)"\n////////////////////////////////////////////////////////////////////////////////////////////////\n");
        return Jwts.builder().setClaims(claims).signWith(SignatureAlgorithm.HS512, secret).compact();
    }

    public static String generateToken(UserInfo user, String secret) {
        try {
            JsonObject userInfo = user.getSource();
            Claims claims = Jwts.claims().setSubject(user.getSub());
            claims.put((Object)"email", (Object)(user.getEmail() + ""));
            claims.put((Object)"role", (Object)(URLEncoder.encode(userInfo.getAsJsonArray("edu_person_entitlements").toString(), "UTF-8") + ""));
            return Jwts.builder().setClaims(claims).signWith(SignatureAlgorithm.HS512, secret).compact();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            logger.error((Object)"UnsupportedEncodingException UTF-8 ", (Throwable)e);
            return "error";
        }
    }
}

