package eu.dnetlib.openaire.user.login.handler;

import com.google.gson.Gson;
import com.google.gson.JsonParser;
import com.nimbusds.jwt.JWT;
import eu.dnetlib.openaire.user.login.utils.JWTGenerator;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.Jwts;
import org.apache.log4j.Logger;
import org.mitre.openid.connect.model.OIDCAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.Session;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by stefanos on 9/5/2017.
 */
public class FrontEndLinkURIAuthenticationSuccessHandler implements AuthenticationSuccessHandler {

    private static final Logger logger = Logger.getLogger(FrontEndLinkURIAuthenticationSuccessHandler.class);

    private String frontEndURI;
    private String frontPath;
    private String frontDomain;

    @Override
    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IllegalArgumentException, IOException   {

        OIDCAuthenticationToken authOIDC = (OIDCAuthenticationToken) authentication;
        request.getSession().setAttribute(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME, authOIDC.getUserInfo().getEmail());
        try {

//            Cookie jwt = new Cookie("XCsrfToken", JWTGenerator.generateToken(authOIDC, "my-very-secret"));
            Cookie openAIREUser = new Cookie("openAIREUser",  new Gson().toJson(JWTGenerator.generateJsonToken(authOIDC)));
            Cookie accessToken = new Cookie("AccessToken", authOIDC.getAccessTokenValue());
            String regex = "^([A-Za-z0-9-_=]+)\\.([A-Za-z0-9-_=]+)\\.?([A-Za-z0-9-_.+=]*)$";
            Matcher matcher = Pattern.compile(regex).matcher(authOIDC.getAccessTokenValue());
            if (matcher.find()) {
                long exp = new JsonParser().parse(new String(Base64.getDecoder().decode(matcher.group(2)))).getAsJsonObject().get("exp").getAsLong();
                accessToken.setMaxAge((int) (exp - (new Date().getTime()/1000)));
            } else {
                accessToken.setMaxAge(3600);
            }
            openAIREUser.setMaxAge(accessToken.getMaxAge());
            logger.debug("access token: " + authOIDC.getAccessTokenValue());
            logger.debug("refresh token: " + authOIDC.getRefreshTokenValue());
            logger.debug("CREDENTIALS > " + authOIDC.getCredentials());
            logger.debug("Authorities > " + authOIDC.getAuthorities());
            logger.debug("\n\nPrincipals > " + authOIDC.getPrincipal());
            logger.debug("\n\nUser Info > " + authOIDC.getUserInfo());
            logger.debug("\n\nopenAIREUser: " + JWTGenerator.generateJsonToken(authOIDC));
            logger.debug("\n////////////////////////////////////////////////////////////////////////////////////////////////\n");
            accessToken.setPath(frontPath);
            openAIREUser.setPath(frontPath);
            if (frontDomain!=null) {
                accessToken.setDomain(frontDomain);
                openAIREUser.setDomain(frontDomain);
            }
            response.addCookie(accessToken);
            response.addCookie(openAIREUser);
            response.sendRedirect(frontEndURI);

        } catch (IOException e) {
            logger.error("IOException in redirection ", e);
            throw new IOException(e);
        }catch (IllegalArgumentException e) {
            logger.error("IllegalArgumentException in redirection ", e);
            throw new IllegalArgumentException(e);
        }
    }

    public String getFrontEndURI() {
        return frontEndURI;
    }

    public void setFrontEndURI(String frontEndURI) {
        this.frontEndURI = frontEndURI;
    }

    public String getFrontPath() {
        return frontPath;
    }

    public void setFrontPath(String frontPath) {
        this.frontPath = frontPath;
    }

    public String getFrontDomain() {
        return frontDomain;
    }

    public void setFrontDomain(String frontDomain) {
        this.frontDomain = frontDomain;
    }
}


