package eu.dnetlib.openaire.user.login.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import org.apache.log4j.Logger;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AuthoritiesMapper {

    private static final Logger logger = Logger.getLogger(AuthoritiesMapper.class);

    public static Collection<? extends GrantedAuthority> map(JsonArray entitlements) {
        HashSet<SimpleGrantedAuthority> authorities = new HashSet<>();
        //entitlements.add("urn:geant:openaire.eu:group:datasource.opendoar____$$3469:role=member#aai.openaire.eu");
        provideRoles(entitlements, authorities);
        entityRoles(entitlements, authorities);
        return authorities;
    }

    private static void entityRoles(JsonArray entitlements, Set<SimpleGrantedAuthority> authorities) {
        String  regex = "urn:geant:openaire[.]eu:group:([^:]*):?(.*)?:role=member#aai[.]openaire[.]eu";
        for(JsonElement obj: entitlements) {
            Matcher matcher = Pattern.compile(regex).matcher(obj.getAsString());
            if (matcher.find()) {
                StringBuilder sb = new StringBuilder();
                if(matcher.group(1) != null && matcher.group(1).length() > 0) {
                    sb.append(matcher.group(1).replace("+-+", "_").replaceAll("[+.]", "_").toUpperCase());
                }
                if(matcher.group(2).length() > 0) {
                    sb.append("_");
                    if(matcher.group(2).equals("admins")) {
                        sb.append("MANAGER");
                    } else  {
                        sb.append(matcher.group(2).toUpperCase());
                    }
                }
                authorities.add(new SimpleGrantedAuthority(sb.toString()));
            }
        }
    }

    private static void provideRoles(JsonArray entitlements, Set<SimpleGrantedAuthority> authorities) {
        Map<String, String> userRoles = new HashMap(){{
            put("urn:geant:openaire.eu:group:Super+Administrator:role=member#aai.openaire.eu", "ROLE_ADMIN");
            put("urn:geant:openaire.eu:group:Content+Provider+Dashboard+Administrator:role=member#aai.openaire.eu","ROLE_PROVIDE_ADMIN");
        }};
        Map<String,SimpleGrantedAuthority> userRolesMap = new HashMap<>();
        userRoles.forEach((openaireRole, appRole) -> userRolesMap.put(openaireRole, new SimpleGrantedAuthority(appRole)));
        authorities.add(new SimpleGrantedAuthority("ROLE_USER"));
        if(entitlements != null) {
            entitlements.forEach(role -> {
                SimpleGrantedAuthority authority = userRolesMap.get(role.getAsString());
                if (authority != null) {
                    authorities.add(authority);
                }
            });
        }
    }
}
