/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.guideline.openaire;

import eu.dnetlib.validator2.validation.guideline.Builders;
import eu.dnetlib.validator2.validation.guideline.Cardinality;
import eu.dnetlib.validator2.validation.guideline.ElementSpec;
import eu.dnetlib.validator2.validation.guideline.Guideline;
import eu.dnetlib.validator2.validation.guideline.SyntheticGuideline;
import eu.dnetlib.validator2.validation.guideline.openaire.AbstractOpenAireProfile;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.w3c.dom.Document;

public final class F3_01M
extends AbstractOpenAireProfile {
    private static final String[] RESOURCE_IDENTIFIER_TYPES = new String[]{"ARK", "DOI", "Handle", "IGSN", "arXiv", "PURL", "URL", "URN", "PMID"};
    private static final String[] PERSISTENT_IDENTIFIER_TYPES = new String[]{"IGSN", "QID", "ARK", "IVOA", "CAS RN", "RRID", "URL", "RInChi", "ERM", "ISO 27729:2012 ISNI", "EC Number", "PURL", "LSID", "TFClass Schema", "InChI", "w3id", "Handle", "DOI", "ORCID iD", "arXiv"};
    private static final ElementSpec F3_01M_SPEC_1 = Builders.forMandatoryElement("identifier", Cardinality.ONE_TO_N).withMandatoryAttribute("identifierType", RESOURCE_IDENTIFIER_TYPES).build();
    private static final ElementSpec F3_01M_SPEC_2 = Builders.forMandatoryElement("alternateIdentifier", Cardinality.ONE_TO_N).withMandatoryAttribute("identifierType", PERSISTENT_IDENTIFIER_TYPES).build();
    public static SyntheticGuideline F3_01M_1 = SyntheticGuideline.of("Identifier", 2, F3_01M_SPEC_1);
    public static SyntheticGuideline F3_01M_2 = SyntheticGuideline.of("AlternateIdentifier", 2, F3_01M_SPEC_2);
    private static final List<Guideline<Document>> GUIDELINES = Collections.unmodifiableList(Arrays.asList(F3_01M_1, F3_01M_2));
    private static final Map<String, Guideline> GUIDELINE_MAP = GUIDELINES.stream().collect(Collectors.toMap(Guideline::getName, guideline -> guideline));
    private static final int MAX_SCORE = GUIDELINES.stream().map(Guideline::getWeight).reduce(0, Integer::sum);

    public F3_01M() {
        super("Metadata includes the identifier for the data");
    }

    @Override
    public Collection<? extends Guideline<Document>> guidelines() {
        return GUIDELINES;
    }

    public Guideline guideline(String guidelineName) {
        return GUIDELINE_MAP.get(guidelineName);
    }

    @Override
    public int maxScore() {
        return MAX_SCORE;
    }
}

