/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.guideline.openaire;

import eu.dnetlib.validator2.validation.guideline.Builders;
import eu.dnetlib.validator2.validation.guideline.Cardinality;
import eu.dnetlib.validator2.validation.guideline.ElementSpec;
import eu.dnetlib.validator2.validation.guideline.Guideline;
import eu.dnetlib.validator2.validation.guideline.RequirementLevel;
import eu.dnetlib.validator2.validation.guideline.SyntheticGuideline;
import eu.dnetlib.validator2.validation.guideline.openaire.AbstractOpenAireProfile;
import eu.dnetlib.validator2.validation.guideline.openaire.F2_01M_SPEC;
import eu.dnetlib.validator2.validation.guideline.openaire.F3_01M_SPEC;
import eu.dnetlib.validator2.validation.guideline.openaire.I2_01M_SPEC;
import eu.dnetlib.validator2.validation.guideline.openaire.R1_01M_SPEC;
import eu.dnetlib.validator2.validation.guideline.openaire.R1_2_01M_SPEC;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.w3c.dom.Document;

public final class FAIR_Literature_GuidelinesV4Profile
extends AbstractOpenAireProfile {
    private static final String[] TITLE_TYPES = new String[]{"AlternativeTitle", "Subtitle", "TranslatedTitle", "Other"};
    private static final String[] NAME_TYPES = new String[]{"Organizational", "Personal"};
    private static final String[] CONTRIBUTOR_TYPES = new String[]{"ContactPerson", "DataCollector", "DataCurator", "DataManager", "Distributor", "Editor", "HostingInstitution", "Producer", "ProjectLeader", "ProjectManager", "ProjectMember", "RegistrationAgency", "RegistrationAuthority", "RelatedPerson", "Researcher", "ResearchGroup", "RightsHolder", "Sponsor", "Supervisor", "WorkPackageLeader", "Other"};
    private static final String[] FUNDER_IDENTIFIER_TYPES = new String[]{"ISNI", "GRID", "Crossref Funder"};
    private static final String[] IDENTIFIER_TYPES = new String[]{"ARK", "arXiv", "bibcode", "DOI", "EAN13", "EISSN", "Handle", "IGSN", "ISBN", "ISSN", "ISTC", "LISSN", "LSID", "PISSN", "PMID", "PURL", "UPC", "URL", "URN", "WOS"};
    private static final String[] RELATION_TYPES = new String[]{"IsCitedBy", "Cites", "IsSupplementTo", "IsSupplementedBy", "IsContinuedBy", "Continues", "IsDescribedBy", "Describes", "HasMetadata", "IsMetadataFor", "HasVersion", "IsVersionOf", "IsNewVersionOf", "IsPreviousVersionOf", "IsPartOf", "HasPart", "IsReferencedBy", "References", "IsDocumentedBy", "Documents", "IsCompiledBy", "Compiles", "IsVariantFormOf", "IsOriginalFormOf", "IsIdenticalTo", "IsReviewedBy", "Reviews", "IsDerivedFrom", "IsSourceOf", "IsRequiredBy", "Requires"};
    private static final String[] RELATED_RESOURCE_GENERAL_TYPES = new String[]{"Audiovisual", "Collection", "DataPaper", "Dataset", "Event", "Image", "InteractiveResource", "Model", "PhysicalObject", "Service", "Software", "Sound", "Text", "Workflow", "Other"};
    private static final String[] EMBARGO_DATE_TYPES = new String[]{"Accepted", "Available"};
    private static final String[] PUBLICATION_DATE_TYPE = new String[]{"Issued"};
    private static final String[] RESOURCE_GENERAL_TYPES = new String[]{"literature", "dataset", "software", "other research product"};
    private static final String[] RESOURCE_CONCEPT_URIS = new String[]{"http://purl.org/coar/resource_type/c_1162", "http://purl.org/coar/resource_type/c_6501", "http://purl.org/coar/resource_type/c_545b", "http://purl.org/coar/resource_type/c_b239", "http://purl.org/coar/resource_type/c_2df8fbb1", "http://purl.org/coar/resource_type/c_dcae04bc", "http://purl.org/coar/resource_type/c_beb9", "http://purl.org/coar/resource_type/c_3e5a", "http://purl.org/coar/resource_type/c_ba08", "http://purl.org/coar/resource_type/c_3248", "http://purl.org/coar/resource_type/c_2f33", "http://purl.org/coar/resource_type/c_86bc", "http://purl.org/coar/resource_type/c_816b", "http://purl.org/coar/resource_type/c_8042", "http://purl.org/coar/resource_type/c_71bd", "http://purl.org/coar/resource_type/c_18gh", "http://purl.org/coar/resource_type/c_18ws", "http://purl.org/coar/resource_type/c_18hj", "http://purl.org/coar/resource_type/c_18op", "http://purl.org/coar/resource_type/c_186u", "http://purl.org/coar/resource_type/c_18wq", "http://purl.org/coar/resource_type/c_18wz", "http://purl.org/coar/resource_type/c_18ww", "http://purl.org/coar/resource_type/c_efa0", "http://purl.org/coar/resource_type/c_baaf", "http://purl.org/coar/resource_type/c_ba1f", "http://purl.org/coar/resource_type/c_93fc", "http://purl.org/coar/resource_type/c_15cd", "http://purl.org/coar/resource_type/c_18co", "http://purl.org/coar/resource_type/c_18cp", "http://purl.org/coar/resource_type/c_6670", "http://purl.org/coar/resource_type/c_5794", "http://purl.org/coar/resource_type/c_c94f", "http://purl.org/coar/resource_type/c_f744", "http://purl.org/coar/resource_type/c_7a1f", "http://purl.org/coar/resource_type/c_bdcc", "http://purl.org/coar/resource_type/c_db06", "http://purl.org/coar/resource_type/c_46ec", "http://purl.org/coar/resource_type/c_0857", "http://purl.org/coar/resource_type/c_8544", "http://purl.org/coar/resource_type/c_18cf", "http://purl.org/coar/resource_type/c_18cw", "http://purl.org/coar/resource_type/c_18cd", "http://purl.org/coar/resource_type/c_18cc", "http://purl.org/coar/resource_type/c_12ce", "http://purl.org/coar/resource_type/c_8a7e", "http://purl.org/coar/resource_type/c_ecc8", "http://purl.org/coar/resource_type/c_c513", "http://purl.org/coar/resource_type/c_12cd", "http://purl.org/coar/resource_type/c_12cc", "http://purl.org/coar/resource_type/c_5ce6", "http://purl.org/coar/resource_type/c_ddb1", "http://purl.org/coar/resource_type/c_e9a0", "http://purl.org/coar/resource_type/c_7ad9", "http://purl.org/coar/resource_type/c_393c", "http://purl.org/coar/resource_type/c_1843"};
    private static final String[] RESOURCE_IDENTIFIER_TYPES = new String[]{"ARK", "DOI", "Handle", "PURL", "URL", "URN"};
    private static final String[] ACCESS_RIGHTS_TYPES = new String[]{"open access", "embargoed access", "restricted access", "metadata only access"};
    private static final String[] ACCESS_RIGHTS_URIS = new String[]{"http://purl.org/coar/access_right/c_abf2", "http://purl.org/coar/access_right/c_f1cf", "http://purl.org/coar/access_right/c_16ec", "http://purl.org/coar/access_right/c_14cb"};
    private static final String[] RESOURCE_VERSION_URIS = new String[]{"http://purl.org/coar/version/c_b1a7d7d4d402bcce", "http://purl.org/coar/version/c_71e4c1898caa6e32", "http://purl.org/coar/version/c_ab4af688f83e57aa", "http://purl.org/coar/version/c_fa2ee174bc00049f", "http://purl.org/coar/version/c_970fb48d4fbd8a85", "http://purl.org/coar/version/c_e19f295774971610", "http://purl.org/coar/version/c_dc82b40f9837b551", "http://purl.org/coar/version/c_be7fb7dd8ff6fe43"};
    private static final String[] RESOURCE_VERSION_LABELS = new String[]{"AO", "SMUR", "AM", "P", "VoR", "CVoR", "EVoR", "NA"};
    private static final String[] FILE_OBJECT_TYPES = new String[]{"fulltext", "dataset", "software", "other"};
    private static final String[] AUDIENCE_VOCABULARY = new String[]{"Administrators", "Community Groups", "Counsellors", "Federal Funds Recipients and Applicants", "Librarians", "News Media", "Other", "Parents and Families", "Policymakers", "Researchers", "School Support Staff", "Student Financial Aid Providers", "Students", "Teachers"};
    private static final ElementSpec F1_01D_SPEC = Builders.forMandatoryElement("datacite:identifier", Cardinality.ONE).withMandatoryAttribute("identifierType", RESOURCE_IDENTIFIER_TYPES).build();
    private static final ElementSpec F1_02D_SPEC = Builders.forMandatoryElement("datacite:identifier", Cardinality.ONE).withMandatoryAttribute("identifierType", IDENTIFIER_TYPES).build();
    private static final ElementSpec A1_01M_SPEC = Builders.forMandatoryElement("datacite:rights", Cardinality.ONE_TO_N).withMandatoryAttribute("rightsURI", ACCESS_RIGHTS_URIS).build();
    private static final ElementSpec I3_01M_SPEC_1 = Builders.forRecommendedRepeatableElement("datacite:relatedIdentifier").withMandatoryAttribute("relatedIdentifierType", IDENTIFIER_TYPES).withMandatoryAttribute("relationType", RELATION_TYPES).withOptionalAttribute("relatedMetadataScheme").withOptionalAttribute("schemeURI").withOptionalAttribute("schemeType").withOptionalAttribute("resourceTypeGeneral", RELATED_RESOURCE_GENERAL_TYPES).build();
    private static final ElementSpec R1_1_01M_SPEC = Builders.forRecommendedElement("oaire:licenseCondition").withMandatoryIfApplicableAttribute("uri", FAIR_Literature_GuidelinesV4Profile.elementIsPresent("oaire:licenseCondition")).withMandatoryIfApplicableAttribute("startDate", FAIR_Literature_GuidelinesV4Profile.elementIsPresent("oaire:licenseCondition")).build();
    public static SyntheticGuideline F1_01D = SyntheticGuideline.of("Data is identified by a persistent identifier", "F1.1", "description", "https://guidelines.openaire.eu", "F", 10, RequirementLevel.MANDATORY, F1_01D_SPEC);
    public static SyntheticGuideline F1_02D = SyntheticGuideline.of("Data is identified by a globally unique identifier", "description", "https://guidelines.openaire.eu", "F", 10, RequirementLevel.MANDATORY, F1_02D_SPEC);
    public static SyntheticGuideline A1_01M = SyntheticGuideline.of("Metadata contains information to enable the user to get access to the data", "description", "https://guidelines.openaire.eu", "A", 10, RequirementLevel.MANDATORY, A1_01M_SPEC);
    public static SyntheticGuideline I3_01M_1 = SyntheticGuideline.of("Metadata includes references to other metadata", "description", "https://guidelines.openaire.eu", "I", 10, RequirementLevel.MANDATORY, I3_01M_SPEC_1);
    public static SyntheticGuideline R1_1_01M = SyntheticGuideline.of("Metadata includes information about the licence under which the data can be reused", "description", "https://guidelines.openaire.eu", "R", 10, RequirementLevel.MANDATORY, R1_1_01M_SPEC);
    private static final List<Guideline<Document>> GUIDELINES = Collections.unmodifiableList(Arrays.asList(F1_01D, F1_02D, new F2_01M_SPEC(), new F3_01M_SPEC(), A1_01M, new I2_01M_SPEC(), I3_01M_1, new R1_01M_SPEC(), R1_1_01M, new R1_2_01M_SPEC()));
    private static final Map<String, Guideline> GUIDELINE_MAP = GUIDELINES.stream().collect(Collectors.toMap(Guideline::getName, guideline -> guideline));
    private static final int MAX_SCORE = GUIDELINES.stream().map(Guideline::getWeight).reduce(0, Integer::sum);

    public FAIR_Literature_GuidelinesV4Profile() {
        super("OpenAIRE FAIR Guidelines for for Literature Repositories Profile v4");
    }

    @Override
    public Collection<? extends Guideline<Document>> guidelines() {
        return GUIDELINES;
    }

    public Guideline guideline(String guidelineName) {
        return GUIDELINE_MAP.get(guidelineName);
    }

    @Override
    public int maxScore() {
        return MAX_SCORE;
    }
}

